/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterDeltaTest {
    @Test
    public void testNewBrokers() throws Throwable {
        ClusterDelta delta = new ClusterDelta(this.getBaseImage());
        Assertions.assertEquals((int)0, (int)delta.newBrokers().size());
        for (int i = 4; i <= 6; ++i) {
            delta.replay(new RegisterBrokerRecord().setBrokerId(i).setBrokerEpoch((long)i * 100L).setFenced(true).setRack(null).setIncarnationId(Uuid.randomUuid()));
        }
        Assertions.assertEquals((int)0, (int)delta.newBrokers().size());
        delta.replay(new UnfenceBrokerRecord().setId(1).setEpoch(100L));
        delta.replay(new UnfenceBrokerRecord().setId(4).setEpoch(400L));
        delta.replay(new UnfenceBrokerRecord().setId(5).setEpoch(500L));
        delta.replay(new UnfenceBrokerRecord().setId(6).setEpoch(600L));
        Set newBrokers = delta.newBrokers().stream().map(b -> b.id()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)newBrokers.equals(new HashSet<Integer>(Arrays.asList(1, 4, 5, 6))));
        delta.replay(new FenceBrokerRecord().setId(4).setEpoch(400L));
        newBrokers = delta.newBrokers().stream().map(b -> b.id()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)newBrokers.equals(new HashSet<Integer>(Arrays.asList(1, 5, 6))));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(2).setBrokerEpoch(200L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(6).setBrokerEpoch(600L));
        newBrokers = delta.newBrokers().stream().map(b -> b.id()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)newBrokers.equals(Collections.singleton(5)));
    }

    @Test
    public void testRemovedBrokers() throws Throwable {
        ClusterDelta delta = new ClusterDelta(this.getBaseImage());
        Assertions.assertEquals((int)0, (int)delta.removedBrokers().size());
        for (int i = 4; i <= 6; ++i) {
            delta.replay(new RegisterBrokerRecord().setBrokerId(i).setBrokerEpoch((long)i * 100L).setFenced(true).setRack(null).setIncarnationId(Uuid.randomUuid()));
        }
        Assertions.assertEquals((int)0, (int)delta.removedBrokers().size());
        delta.replay(new UnfenceBrokerRecord().setId(1).setEpoch(100L));
        delta.replay(new UnfenceBrokerRecord().setId(4).setEpoch(400L));
        delta.replay(new UnfenceBrokerRecord().setId(5).setEpoch(500L));
        delta.replay(new UnfenceBrokerRecord().setId(6).setEpoch(600L));
        Assertions.assertEquals((int)0, (int)delta.removedBrokers().size());
        delta.replay(new FenceBrokerRecord().setId(4).setEpoch(400L));
        delta.replay(new FenceBrokerRecord().setId(2).setEpoch(200L));
        Assertions.assertTrue((boolean)delta.removedBrokers().equals(Collections.singleton(2)));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(2).setBrokerEpoch(200L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(6).setBrokerEpoch(600L));
        Assertions.assertTrue((boolean)delta.removedBrokers().equals(new HashSet<Integer>(Arrays.asList(1, 2))));
    }

    private ClusterImage getBaseImage() {
        HashMap<Integer, BrokerRegistration> brokers = new HashMap<Integer, BrokerRegistration>(){
            {
                this.put(1, new BrokerRegistration(1, 100L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true, false));
                this.put(2, new BrokerRegistration(2, 200L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false));
                this.put(3, new BrokerRegistration(3, 300L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false));
            }
        };
        ClusterImage baseImage = new ClusterImage((Map)brokers);
        return baseImage;
    }
}

