/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerControlState;
import org.apache.kafka.controller.BrokerControlStates;
import org.apache.kafka.controller.BrokerHeartbeatManager;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokerHeartbeatManagerTest {
    private static BrokerHeartbeatManager newBrokerHeartbeatManager() {
        LogContext logContext = new LogContext();
        MockTime time = new MockTime(0L, 1000000L, 0L);
        return new BrokerHeartbeatManager(logContext, (Time)time, 10000000L);
    }

    @Test
    public void testHasValidSession() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        MockTime time = (MockTime)manager.time();
        Assertions.assertFalse((boolean)manager.hasValidSession(0));
        manager.touch(0, false, 0L);
        time.sleep(5L);
        manager.touch(1, false, 0L);
        manager.touch(2, false, 0L);
        Assertions.assertTrue((boolean)manager.hasValidSession(0));
        Assertions.assertTrue((boolean)manager.hasValidSession(1));
        Assertions.assertTrue((boolean)manager.hasValidSession(2));
        Assertions.assertFalse((boolean)manager.hasValidSession(3));
        time.sleep(6L);
        Assertions.assertFalse((boolean)manager.hasValidSession(0));
        Assertions.assertTrue((boolean)manager.hasValidSession(1));
        Assertions.assertTrue((boolean)manager.hasValidSession(2));
        Assertions.assertFalse((boolean)manager.hasValidSession(3));
        manager.remove(2);
        Assertions.assertFalse((boolean)manager.hasValidSession(2));
        manager.remove(1);
        Assertions.assertFalse((boolean)manager.hasValidSession(1));
    }

    @Test
    public void testFindOneStaleBroker() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        MockTime time = (MockTime)manager.time();
        Assertions.assertFalse((boolean)manager.hasValidSession(0));
        manager.touch(0, false, 0L);
        time.sleep(5L);
        manager.touch(1, false, 0L);
        time.sleep(1L);
        manager.touch(2, false, 0L);
        BrokerHeartbeatManager.BrokerHeartbeatStateIterator iter = manager.unfenced().iterator();
        Assertions.assertEquals((int)0, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)1, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)2, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        time.sleep(5L);
        Assertions.assertEquals(Optional.of(0), (Object)manager.findOneStaleBroker());
        manager.fence(0);
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        iter = manager.unfenced().iterator();
        Assertions.assertEquals((int)1, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)2, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertFalse((boolean)iter.hasNext());
        time.sleep(20L);
        Assertions.assertEquals(Optional.of(1), (Object)manager.findOneStaleBroker());
        manager.fence(1);
        Assertions.assertEquals(Optional.of(2), (Object)manager.findOneStaleBroker());
        manager.fence(2);
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        iter = manager.unfenced().iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testNextCheckTimeNs() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        MockTime time = (MockTime)manager.time();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)manager.nextCheckTimeNs());
        manager.touch(0, false, 0L);
        time.sleep(2L);
        manager.touch(1, false, 0L);
        time.sleep(1L);
        manager.touch(2, false, 0L);
        time.sleep(1L);
        manager.touch(3, false, 0L);
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        Assertions.assertEquals((long)10000000L, (long)manager.nextCheckTimeNs());
        time.sleep(7L);
        Assertions.assertEquals((long)10000000L, (long)manager.nextCheckTimeNs());
        Assertions.assertEquals(Optional.of(0), (Object)manager.findOneStaleBroker());
        manager.fence(0);
        Assertions.assertEquals((long)12000000L, (long)manager.nextCheckTimeNs());
        time.sleep(3L);
        Assertions.assertEquals(Optional.of(1), (Object)manager.findOneStaleBroker());
        manager.fence(1);
        Assertions.assertEquals(Optional.of(2), (Object)manager.findOneStaleBroker());
        manager.fence(2);
        Assertions.assertEquals((long)14000000L, (long)manager.nextCheckTimeNs());
    }

    @Test
    public void testMetadataOffsetComparator() {
        TreeSet<BrokerHeartbeatManager.BrokerHeartbeatState> set = new TreeSet<BrokerHeartbeatManager.BrokerHeartbeatState>((Comparator<BrokerHeartbeatManager.BrokerHeartbeatState>)BrokerHeartbeatManager.MetadataOffsetComparator.INSTANCE);
        BrokerHeartbeatManager.BrokerHeartbeatState broker1 = new BrokerHeartbeatManager.BrokerHeartbeatState(1);
        BrokerHeartbeatManager.BrokerHeartbeatState broker2 = new BrokerHeartbeatManager.BrokerHeartbeatState(2);
        BrokerHeartbeatManager.BrokerHeartbeatState broker3 = new BrokerHeartbeatManager.BrokerHeartbeatState(3);
        set.add(broker1);
        set.add(broker2);
        set.add(broker3);
        Iterator iterator = set.iterator();
        Assertions.assertEquals((Object)broker1, iterator.next());
        Assertions.assertEquals((Object)broker2, iterator.next());
        Assertions.assertEquals((Object)broker3, iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)set.remove(broker1));
        Assertions.assertTrue((boolean)set.remove(broker2));
        Assertions.assertTrue((boolean)set.remove(broker3));
        Assertions.assertTrue((boolean)set.isEmpty());
        broker1.metadataOffset = 800L;
        broker2.metadataOffset = 400L;
        broker3.metadataOffset = 100L;
        set.add(broker1);
        set.add(broker2);
        set.add(broker3);
        iterator = set.iterator();
        Assertions.assertEquals((Object)broker3, iterator.next());
        Assertions.assertEquals((Object)broker2, iterator.next());
        Assertions.assertEquals((Object)broker1, iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private static Set<UsableBroker> usableBrokersToSet(BrokerHeartbeatManager manager) {
        HashSet<UsableBroker> brokers = new HashSet<UsableBroker>();
        BrokerHeartbeatManager.UsableBrokerIterator iterator = new BrokerHeartbeatManager.UsableBrokerIterator(manager.brokers().iterator(), id -> id % 2 == 0 ? Optional.of("rack1") : Optional.of("rack2"), Collections.emptySet());
        while (iterator.hasNext()) {
            brokers.add((UsableBroker)iterator.next());
        }
        return brokers;
    }

    @Test
    public void testUsableBrokerIterator() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, false, 98L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        Assertions.assertEquals((long)98L, (long)manager.lowestActiveOffset());
        HashSet<UsableBroker> expected = new HashSet<UsableBroker>();
        expected.add(new UsableBroker(0, Optional.of("rack1"), false));
        expected.add(new UsableBroker(1, Optional.of("rack2"), false));
        expected.add(new UsableBroker(2, Optional.of("rack1"), false));
        expected.add(new UsableBroker(3, Optional.of("rack2"), false));
        expected.add(new UsableBroker(4, Optional.of("rack1"), true));
        Assertions.assertEquals(expected, BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        manager.maybeUpdateControlledShutdownOffset(2, 0L);
        Assertions.assertEquals((long)100L, (long)manager.lowestActiveOffset());
        Assertions.assertThrows(RuntimeException.class, () -> manager.maybeUpdateControlledShutdownOffset(4, 0L));
        manager.touch(4, false, 100L);
        manager.maybeUpdateControlledShutdownOffset(4, 0L);
        expected.remove(new UsableBroker(2, Optional.of("rack1"), false));
        expected.remove(new UsableBroker(4, Optional.of("rack1"), true));
        Assertions.assertEquals(expected, BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
    }

    @Test
    public void testUsableBrokers() {
        Function<Integer, Optional> brokerIdToRack = id -> Optional.of(Integer.toString(id % 3));
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        for (int i = 0; i < 10; ++i) {
            manager.touch(i, false, 100L);
        }
        HashSet<Integer> excluded = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        Iterator iter = manager.usableBrokers(brokerIdToRack, excluded);
        while (iter.hasNext()) {
            Assertions.assertFalse((boolean)excluded.contains(((UsableBroker)iter.next()).id()));
        }
    }

    @Test
    public void testControlledShutdownOffsetIsOnlyUpdatedOnce() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, false, 98L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)manager.controlledShutdownOffset(2));
        manager.maybeUpdateControlledShutdownOffset(2, 98L);
        Assertions.assertEquals((Object)OptionalLong.of(98L), (Object)manager.controlledShutdownOffset(2));
        manager.maybeUpdateControlledShutdownOffset(2, 99L);
        Assertions.assertEquals((Object)OptionalLong.of(98L), (Object)manager.controlledShutdownOffset(2));
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)manager.controlledShutdownOffset(3));
        manager.maybeUpdateControlledShutdownOffset(3, 101L);
        Assertions.assertEquals((Object)OptionalLong.of(101L), (Object)manager.controlledShutdownOffset(3));
        manager.maybeUpdateControlledShutdownOffset(3, 102L);
        Assertions.assertEquals((Object)OptionalLong.of(101L), (Object)manager.controlledShutdownOffset(3));
    }

    @Test
    public void testBrokerHeartbeatStateList() {
        BrokerHeartbeatManager.BrokerHeartbeatStateList list = new BrokerHeartbeatManager.BrokerHeartbeatStateList();
        Assertions.assertEquals(null, (Object)list.first());
        BrokerHeartbeatManager.BrokerHeartbeatStateIterator iterator = list.iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
        BrokerHeartbeatManager.BrokerHeartbeatState broker0 = new BrokerHeartbeatManager.BrokerHeartbeatState(0);
        broker0.lastContactNs = 200L;
        BrokerHeartbeatManager.BrokerHeartbeatState broker1 = new BrokerHeartbeatManager.BrokerHeartbeatState(1);
        broker1.lastContactNs = 100L;
        BrokerHeartbeatManager.BrokerHeartbeatState broker2 = new BrokerHeartbeatManager.BrokerHeartbeatState(2);
        broker2.lastContactNs = 50L;
        BrokerHeartbeatManager.BrokerHeartbeatState broker3 = new BrokerHeartbeatManager.BrokerHeartbeatState(3);
        broker3.lastContactNs = 150L;
        list.add(broker0);
        list.add(broker1);
        list.add(broker2);
        list.add(broker3);
        Assertions.assertEquals((Object)broker2, (Object)list.first());
        iterator = list.iterator();
        Assertions.assertEquals((Object)broker2, (Object)iterator.next());
        Assertions.assertEquals((Object)broker1, (Object)iterator.next());
        Assertions.assertEquals((Object)broker3, (Object)iterator.next());
        Assertions.assertEquals((Object)broker0, (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        list.remove(broker1);
        iterator = list.iterator();
        Assertions.assertEquals((Object)broker2, (Object)iterator.next());
        Assertions.assertEquals((Object)broker3, (Object)iterator.next());
        Assertions.assertEquals((Object)broker0, (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCalculateNextBrokerState() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        manager.touch(0, true, 100L);
        manager.touch(1, false, 98L);
        manager.touch(2, false, 100L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        manager.touch(5, false, 99L);
        manager.maybeUpdateControlledShutdownOffset(5, 99L);
        Assertions.assertEquals((long)98L, (long)manager.lowestActiveOffset());
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.UNFENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(false).setCurrentMetadataOffset(100L), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.FENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(false).setCurrentMetadataOffset(50L), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.FENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.UNFENCED), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantFence(false), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        manager.fence(1);
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
    }
}

