/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.ControllerMetricsManager;
import org.apache.kafka.controller.MockControllerMetrics;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class ControllerMetricsManagerTest {
    ControllerMetricsManagerTest() {
    }

    @Test
    public void testActiveBrokerRegistration() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, false));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testFenceBrokerRegistration() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerChangedToActive() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.UNFENCE));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerLegacyChangedToActive() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnfence(1, 1L));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerChangedToFence() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, false));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.FENCE));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerLegacyChangedToFence() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, false));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerFence(1, 1L));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerUnchanged() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.NONE));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerUnregister() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(2, 1L, false));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnregistration(1, 1L));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnregistration(2, 1L));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testReplayBatch() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replayBatch(0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true), 0), new ApiMessageAndVersion((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.UNFENCE), 0)));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testTopicCountIncreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test"));
        Assertions.assertEquals((int)1, (int)metrics.globalTopicCount());
    }

    @Test
    public void testTopicCountDecreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(id));
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
    }

    @Test
    public void testPartitionCountIncreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)1, (int)metrics.globalPartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 1, 0, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)2, (int)metrics.globalPartitionCount());
    }

    @Test
    public void testPartitionCountDecreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 1, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(id));
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
    }

    @Test
    public void testOfflinePartition() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, -1, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)1, (int)metrics.offlinePartitionCount());
    }

    @Test
    public void testImbalancedPartition() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 1, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)1, (int)metrics.preferredReplicaImbalanceCount());
    }

    @Test
    public void testPartitionChange() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(-1), Optional.empty()));
        Assertions.assertEquals((int)1, (int)metrics.offlinePartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(1), Optional.empty()));
        Assertions.assertEquals((int)0, (int)metrics.offlinePartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(0), Optional.empty()));
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.empty(), Optional.of(Arrays.asList(1, 2, 0))));
        Assertions.assertEquals((int)1, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(2), Optional.of(Arrays.asList(2, 0, 1))));
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
    }

    @Test
    public void testStartingMetrics() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.offlinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
    }

    @Test
    public void testReset() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = new ControllerMetricsManager((ControllerMetrics)metrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2)));
        manager.reset();
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.offlinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
    }

    private static RegisterBrokerRecord brokerRegistration(int brokerId, long epoch, boolean fenced) {
        return new RegisterBrokerRecord().setBrokerId(brokerId).setIncarnationId(Uuid.randomUuid()).setBrokerEpoch(epoch).setFenced(fenced);
    }

    private static UnregisterBrokerRecord brokerUnregistration(int brokerId, long epoch) {
        return new UnregisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(epoch);
    }

    private static BrokerRegistrationChangeRecord brokerChange(int brokerId, long epoch, BrokerRegistrationFencingChange fencing) {
        return new BrokerRegistrationChangeRecord().setBrokerId(brokerId).setBrokerEpoch(epoch).setFenced(fencing.value());
    }

    private static UnfenceBrokerRecord brokerUnfence(int brokerId, long epoch) {
        return new UnfenceBrokerRecord().setId(brokerId).setEpoch(epoch);
    }

    private static FenceBrokerRecord brokerFence(int brokerId, long epoch) {
        return new FenceBrokerRecord().setId(brokerId).setEpoch(epoch);
    }

    private static TopicRecord topicRecord(String name) {
        return new TopicRecord().setName(name).setTopicId(Uuid.randomUuid());
    }

    private static TopicRecord topicRecord(String name, Uuid id) {
        return new TopicRecord().setName(name).setTopicId(id);
    }

    private static RemoveTopicRecord removeTopicRecord(Uuid id) {
        return new RemoveTopicRecord().setTopicId(id);
    }

    private static PartitionRecord partitionRecord(Uuid id, int partition, int leader, List<Integer> replicas) {
        return new PartitionRecord().setPartitionId(partition).setTopicId(id).setReplicas(replicas).setIsr(replicas).setLeader(leader);
    }

    private static PartitionChangeRecord partitionChangeRecord(Uuid id, int partition, OptionalInt leader, Optional<List<Integer>> replicas) {
        PartitionChangeRecord record = new PartitionChangeRecord();
        leader.ifPresent(record::setLeader);
        replicas.ifPresent(record::setReplicas);
        replicas.ifPresent(record::setIsr);
        return record.setPartitionId(partition).setTopicId(id);
    }
}

