/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentClusterIdException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ClusterControlManagerTest {
    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class, names={"IBP_3_0_IV1", "IBP_3_3_IV2"})
    public void testReplay(MetadataVersion metadataVersion) {
        BrokerRegistrationChangeRecord changeRecord;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        clusterControl.checkBrokerEpoch(1, 100L);
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(1, 101L));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(2, 100L));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
        if (metadataVersion.isLessThan(MetadataVersion.IBP_3_3_IV2)) {
            UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(1).setEpoch(100L);
            clusterControl.replay(unfenceBrokerRecord);
        } else {
            changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
            clusterControl.replay(changeRecord);
        }
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(1));
        if (metadataVersion.isLessThan(MetadataVersion.IBP_3_3_IV2)) {
            FenceBrokerRecord fenceBrokerRecord = new FenceBrokerRecord().setId(1).setEpoch(100L);
            clusterControl.replay(fenceBrokerRecord);
        } else {
            changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.FENCE.value());
            clusterControl.replay(changeRecord);
        }
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
    }

    @Test
    public void testReplayRegisterBrokerRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(true).setInControlledShutdown(true);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        brokerRecord.setInControlledShutdown(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        brokerRecord.setFenced(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
    }

    @Test
    public void testReplayBrokerRegistrationChangeRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
    }

    @Test
    public void testRegistrationWithIncorrectClusterId() throws Exception {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertThrows(InconsistentClusterIdException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("WIjw3grwRZmR2uOpdpVXbg").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Collections.emptyMap(), 456L)));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class, names={"IBP_3_3_IV2", "IBP_3_3_IV3"})
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(metadataVersion).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        ControllerResult result = clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Collections.emptyMap(), 456L));
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        Assertions.assertEquals(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(123L).setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setFenced(true).setFeatures(new RegisterBrokerRecord.BrokerFeatureCollection(Arrays.asList(new RegisterBrokerRecord.BrokerFeature().setName("metadata.version").setMinSupportedVersion((short)1).setMaxSupportedVersion((short)1)).iterator())).setInControlledShutdown(false), expectedVersion)), (Object)result.records());
    }

    @Test
    public void testUnregister() throws Exception {
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("arack");
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertEquals((Object)new BrokerRegistration(1, 100L, Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w"), Collections.singletonMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "example.com", 9092)), Collections.emptyMap(), Optional.of("arack"), true, false), clusterControl.brokerRegistrations().get(1));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        UnregisterBrokerRecord unregisterRecord = new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L);
        clusterControl.replay(unregisterRecord);
        Assertions.assertFalse((boolean)clusterControl.brokerRegistrations().containsKey(1));
        Assertions.assertFalse((boolean)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).isPresent());
    }

    @ParameterizedTest
    @ValueSource(ints={3, 10})
    public void testPlaceReplicas(int numUsableBrokers) throws Exception {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        final ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        for (i = 0; i < numUsableBrokers; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i);
            brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            UnfenceBrokerRecord unfenceRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceRecord);
            clusterControl.heartbeatManager().touch(i, false, 0L);
        }
        for (i = 0; i < numUsableBrokers; ++i) {
            Assertions.assertTrue((boolean)clusterControl.isUnfenced(i), (String)String.format("broker %d was not unfenced.", i));
        }
        for (i = 0; i < 100; ++i) {
            List results = clusterControl.replicaPlacer().place(new PlacementSpec(0, 1, 3), new ClusterDescriber(){

                public Iterator<UsableBroker> usableBrokers() {
                    return clusterControl.usableBrokers();
                }
            });
            HashSet<Integer> seen = new HashSet<Integer>();
            for (Integer result : (List)results.get(0)) {
                Assertions.assertTrue((result >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((result < numUsableBrokers ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)seen.add(result));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class, names={"IBP_3_3_IV2", "IBP_3_3_IV3"})
    public void testIterator(MetadataVersion metadataVersion) throws Exception {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(metadataVersion).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        for (i = 0; i < 3; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i).setRack(null);
            brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092 + i).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
        }
        for (i = 0; i < 2; ++i) {
            UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceBrokerRecord);
        }
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        RecordTestUtils.assertBatchIteratorContains(Arrays.asList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com")).iterator())).setInControlledShutdown(metadataVersion.isInControlledShutdownStateSupported()).setFenced(false), expectedVersion)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(false), expectedVersion)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(2).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9094).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(true), expectedVersion))), (Iterator<List<ApiMessageAndVersion>>)clusterControl.iterator(Long.MAX_VALUE));
    }

    @Test
    public void testRegistrationWithUnsupportedMetadataVersion() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), Collections.singletonMap("metadata.version", VersionRange.of((short)MetadataVersion.IBP_3_1_IV0.featureLevel(), (short)MetadataVersion.IBP_3_3_IV0.featureLevel())), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_3_IV0).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertEquals((Object)"Unable to register because the broker does not support version 4 of metadata.version. It wants a version between 1 and 1, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE)))).getMessage());
        Assertions.assertEquals((Object)"Unable to register because the broker does not support version 4 of metadata.version. It wants a version between 7 and 7, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_3_IV3.featureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_3_IV3.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE)))).getMessage());
    }
}

