/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.util.LocalDirectorySource;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LocalDirectorySourceTest {
    private static final String[] LISTING1 = new String[]{"00000000000000000000.index", "00000000000000000000.log", "00000000000000000000.timeindex", "00000000000000004758.snapshot", "00000000000000004794.snapshot", "leader-epoch-checkpoint", "partition.metadata", "quorum-state"};
    private static final String[] LISTING2 = new String[]{"00000000000000000000.index", "00000000000000000000.log", "00000000000000000000.timeindex", "00000000000000004501-0000000020.checkpoint", "00000000000000004567.index", "00000000000000004567.log", "00000000000000004567.timeindex", "00000000000000004758.snapshot", "00000000000000004794.snapshot", "leader-epoch-checkpoint", "partition.metadata", "quorum-state"};

    LocalDirectorySourceTest() {
    }

    private static String runSelect(boolean considerSnapshots, long lastReadOffset, String ... names) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String name : names) {
            paths.add(Paths.get(name, new String[0]));
        }
        return LocalDirectorySource.selectNextFileName((boolean)considerSnapshots, (long)lastReadOffset, paths.iterator());
    }

    @Test
    public void testSelectNextFileName() {
        Assertions.assertEquals((Object)"00000000000000000000.log", (Object)LocalDirectorySourceTest.runSelect(false, -1L, LISTING1));
        Assertions.assertEquals((Object)"00000000000000000000.log", (Object)LocalDirectorySourceTest.runSelect(true, -1L, LISTING1));
        Assertions.assertEquals((Object)"", (Object)LocalDirectorySourceTest.runSelect(false, 1000L, LISTING1));
    }

    @Test
    public void testSelectNextFileNameWithSnapshots() {
        Assertions.assertEquals((Object)"00000000000000000000.log", (Object)LocalDirectorySourceTest.runSelect(false, -1L, LISTING2));
        Assertions.assertEquals((Object)"00000000000000004501-0000000020.checkpoint", (Object)LocalDirectorySourceTest.runSelect(true, -1L, LISTING2));
        Assertions.assertEquals((Object)"00000000000000004567.log", (Object)LocalDirectorySourceTest.runSelect(false, 4501L, LISTING2));
        Assertions.assertEquals((Object)"", (Object)LocalDirectorySourceTest.runSelect(false, 6000L, LISTING2));
    }

    @Test
    public void testExtractLogFileOffsetFromName() {
        Assertions.assertEquals((long)0L, (long)LocalDirectorySource.extractLogFileOffsetFromName((String)"00000000000000000000.log"));
        Assertions.assertEquals((long)449000400000L, (long)LocalDirectorySource.extractLogFileOffsetFromName((String)"00000000449000400000.log"));
    }

    @Test
    public void testExtractSnapshotFileOffsetFromName() {
        Assertions.assertEquals((long)4501L, (long)LocalDirectorySource.extractSnapshotFileOffsetFromName((String)"00000000000000004501-0000000020.checkpoint"));
    }

    @Test
    public void testCalculateSnapshotId() {
        Assertions.assertEquals((Object)new OffsetAndEpoch(4501L, 20), (Object)LocalDirectorySource.calculateSnapshotId((String)"00000000000000004501-0000000020.checkpoint"));
    }

    @Test
    public void testParseControlRecords() {
        Assertions.assertEquals(Optional.empty(), (Object)LocalDirectorySource.parseControlRecords((Batch)Batch.data((long)1000L, (int)123, (long)456L, (int)200, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new SnapshotHeaderRecord(), 0)))));
        Assertions.assertEquals(Optional.of(new LeaderAndEpoch(OptionalInt.of(5), 123)), (Object)LocalDirectorySource.parseControlRecords((Batch)Batch.data((long)1000L, (int)123, (long)456L, (int)200, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new SnapshotHeaderRecord(), 0), new ApiMessageAndVersion((ApiMessage)new LeaderChangeMessage().setLeaderId(5), 0)))));
        Assertions.assertEquals(Optional.of(new LeaderAndEpoch(OptionalInt.empty(), 123)), (Object)LocalDirectorySource.parseControlRecords((Batch)Batch.data((long)1000L, (int)123, (long)456L, (int)200, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new SnapshotHeaderRecord(), 0), new ApiMessageAndVersion((ApiMessage)new LeaderChangeMessage().setLeaderId(6), 0), new ApiMessageAndVersion((ApiMessage)new LeaderChangeMessage().setLeaderId(-1), 0)))));
    }
}

