/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ClusterLinksImageTest;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MockSnapshotConsumer;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TopicsImageTest {
    static final TopicsImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final TopicsDelta DELTA1;
    static final TopicsImage IMAGE2;
    static final List<TopicImage> TOPIC_IMAGES1;
    private static final Uuid FOO_UUID;
    private static final Uuid BAR_UUID;
    private static final Uuid BAZ_UUID;
    private static final MirrorTopic NULL_MIRROR_TOPIC_STATE;
    private static final MirrorTopic ACTIVE_MIRROR_TOPIC_STATE;
    private static final MirrorTopic FAILED_MIRROR_TOPIC_STATE;

    private static TopicImage newTopicImage(String name, Uuid id, MirrorTopic mirrorTopic, PartitionRegistration ... partitions) {
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration partition : partitions) {
            partitionMap.put(i++, partition);
        }
        return new TopicImage(name, id, partitionMap, mirrorTopic);
    }

    private static Map<Uuid, TopicImage> newTopicsByIdMap(Collection<TopicImage> topics) {
        HashMap<Uuid, TopicImage> map = new HashMap<Uuid, TopicImage>();
        for (TopicImage topic : topics) {
            map.put(topic.id(), topic);
        }
        return map;
    }

    private static Map<String, TopicImage> newTopicsByNameMap(Collection<TopicImage> topics) {
        HashMap<String, TopicImage> map = new HashMap<String, TopicImage>();
        for (TopicImage topic : topics) {
            map.put(topic.name(), topic);
        }
        return map;
    }

    private static Map<Uuid, List<TopicImage>> newTopicsByLinkIdMap(Collection<TopicImage> topics) {
        HashMap<Uuid, List<TopicImage>> map = new HashMap<Uuid, List<TopicImage>>();
        for (TopicImage topic : topics) {
            if (!topic.mirrorTopic().isPresent()) continue;
            Uuid linkId = ((MirrorTopic)topic.mirrorTopic().get()).linkId();
            List images = map.getOrDefault(linkId, new ArrayList());
            images.add(topic);
            map.put(linkId, images);
        }
        return map;
    }

    private ApiMessageAndVersion newPartitionRecord(Uuid topicId, int partitionId, List<Integer> replicas) {
        return new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(replicas).setIsr(replicas).setLeader(replicas.get(0)).setLeaderEpoch(1).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion());
    }

    private PartitionRegistration newPartition(int[] replicas) {
        return new PartitionRegistration(replicas, replicas, Replicas.NONE, Replicas.NONE, replicas[0], LeaderRecoveryState.RECOVERED, 1, 1);
    }

    @Test
    public void testBasicLocalChanges() {
        int localId = 3;
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>(DELTA1_RECORDS);
        Uuid newFooId = Uuid.fromString((String)"b66ybsWIQoygs01vdjH07A");
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(newFooId), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        topicRecords.add(this.newPartitionRecord(newFooId, 0, Arrays.asList(0, 1, 2)));
        topicRecords.add(this.newPartitionRecord(newFooId, 1, Arrays.asList(0, 1, localId)));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(4, 2, localId)).setIsr(Arrays.asList(4, 2, localId)).setLeader(4).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("foo", 1))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("baz", 0))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("baz", 1), new TopicPartition("bar", 0), new TopicPartition("foo", 1))), changes.followers().keySet());
    }

    @Test
    public void testDeleteAfterChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{localId, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), Collections.emptyMap(), Collections.emptyMap());
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(zooId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0))), (Object)changes.deletes());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.leaders());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.followers());
    }

    @Test
    public void testLocalReassignmentChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, 2}), this.newPartition(new int[]{0, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), Collections.emptyMap(), Collections.emptyMap());
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(localId), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(1).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(2).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(3).setLeader(0).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(4).setLeader(localId).setIsr(Arrays.asList(localId, 1, 2)).setReplicas(Arrays.asList(localId, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(5).setIsr(Arrays.asList(0, 1, localId)).setReplicas(Arrays.asList(0, 1, localId)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 2), new TopicPartition("zoo", 3))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0), new TopicPartition("zoo", 4))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 1), new TopicPartition("zoo", 5))), changes.followers().keySet());
    }

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(TopicsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(TopicsImage image) throws Throwable {
        MockSnapshotConsumer writer = new MockSnapshotConsumer();
        image.write((Consumer)writer);
        TopicsDelta delta = new TopicsDelta(TopicsImage.EMPTY, __ -> null);
        RecordTestUtils.replayAllBatches(delta, writer.batches());
        TopicsImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    @Test
    public void testTopicNameToIdView() {
        Map map = IMAGE1.topicNameToIdView();
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertEquals((Object)FOO_UUID, map.get("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        Assertions.assertEquals((Object)BAR_UUID, map.get("bar"));
        Assertions.assertFalse((boolean)map.containsKey("baz"));
        Assertions.assertEquals(null, map.get("baz"));
        HashSet uuids = new HashSet();
        map.values().iterator().forEachRemaining(u -> uuids.add(u));
        HashSet<Uuid> expectedUuids = new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA"), Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw")));
        Assertions.assertEquals(expectedUuids, uuids);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            Uuid cfr_ignored_0 = (Uuid)map.remove("foo");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put("bar", FOO_UUID));
    }

    @Test
    public void testTopicIdToNameView() {
        Map map = IMAGE1.topicIdToNameView();
        Assertions.assertTrue((boolean)map.containsKey(FOO_UUID));
        Assertions.assertEquals((Object)"foo", map.get(FOO_UUID));
        Assertions.assertTrue((boolean)map.containsKey(BAR_UUID));
        Assertions.assertEquals((Object)"bar", map.get(BAR_UUID));
        Assertions.assertFalse((boolean)map.containsKey(BAZ_UUID));
        Assertions.assertEquals(null, map.get(BAZ_UUID));
        HashSet names = new HashSet();
        map.values().iterator().forEachRemaining(n -> names.add(n));
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo", "bar"));
        Assertions.assertEquals(expectedNames, names);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)map.remove(FOO_UUID);
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(FOO_UUID, "bar"));
    }

    private void addTopicWithName(TopicsDelta delta, String name) {
        Uuid topicId = new Uuid((long)name.hashCode(), (long)name.hashCode());
        delta.replay(new TopicRecord().setName(name).setTopicId(topicId));
        delta.replay(new PartitionRecord().setPartitionId(0).setTopicId(topicId).setReplicas(Arrays.asList(0, 1, 2)).setIsr(Arrays.asList(0, 1, 2)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setLeader(0).setLeaderEpoch(123).setPartitionEpoch(456));
    }

    @Test
    public void testTenantToTopics() {
        TopicsDelta delta = new TopicsDelta(TopicsImage.EMPTY, (Function)TopicNameToTenant.INSTANCE);
        this.addTopicWithName(delta, "lkc-abcdef_foo");
        this.addTopicWithName(delta, "bar");
        this.addTopicWithName(delta, "lkc-fedcba_foo");
        this.addTopicWithName(delta, "baz");
        this.addTopicWithName(delta, "lkc-fedcba_bar");
        TopicsImage image = delta.apply();
        Assertions.assertEquals(Collections.singleton("lkc-abcdef_foo"), (Object)image.topicsByTenant("lkc-abcdef_"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("lkc-fedcba_foo", "lkc-fedcba_bar")), (Object)image.topicsByTenant("lkc-fedcba_"));
        Assertions.assertEquals(Collections.emptySet(), (Object)image.topicsByTenant("lkc-blahba_"));
        Assertions.assertEquals(Collections.emptySet(), (Object)image.topicsByTenant(""));
    }

    @Test
    public void testDeleteClusterLink() {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("doesn't matter"), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        Assertions.assertFalse((boolean)IMAGE1.topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty());
        Assertions.assertNotNull((Object)IMAGE1.getTopic(BAR_UUID));
        Assertions.assertTrue((boolean)IMAGE1.getTopic(BAR_UUID).mirrorTopic().isPresent());
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, records);
        TopicsImage image = delta.apply();
        Assertions.assertTrue((boolean)image.topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty(), (String)"Link was removed, so expected zero topics");
        Assertions.assertNotNull((Object)image.getTopic(BAR_UUID), (String)"Topic should still exist after un-linking");
        Assertions.assertFalse((boolean)image.getTopic(BAR_UUID).mirrorTopic().isPresent(), (String)"Mirror topic data should not be present after un-linking");
    }

    static {
        FOO_UUID = Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA");
        BAR_UUID = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        BAZ_UUID = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        NULL_MIRROR_TOPIC_STATE = null;
        ACTIVE_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)new MirrorTopicRecord().setTopicName("bar").setTopicId(BAR_UUID).setSourceTopicName("bar").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("Mirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setStoppedLogEndOffsets(Collections.emptyList()));
        FAILED_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)new MirrorTopicRecord().setTopicName("bar").setTopicId(BAR_UUID).setSourceTopicName("bar").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("FailedMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setStoppedLogEndOffsets(Collections.emptyList()));
        TOPIC_IMAGES1 = Arrays.asList(TopicsImageTest.newTopicImage("foo", FOO_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration(new int[]{2, 3, 4}, new int[]{2, 3}, Replicas.NONE, Replicas.NONE, 2, LeaderRecoveryState.RECOVERED, 1, 345), new PartitionRegistration(new int[]{3, 4, 5}, new int[]{3, 4, 5}, Replicas.NONE, Replicas.NONE, 3, LeaderRecoveryState.RECOVERED, 4, 684), new PartitionRegistration(new int[]{2, 4, 5}, new int[]{2, 4, 5}, Replicas.NONE, Replicas.NONE, 2, LeaderRecoveryState.RECOVERED, 10, 84)), TopicsImageTest.newTopicImage("bar", BAR_UUID, ACTIVE_MIRROR_TOPIC_STATE, new PartitionRegistration(new int[]{0, 1, 2, 3, 4}, new int[]{0, 1, 2, 3}, new int[]{1}, new int[]{3, 4}, 0, LeaderRecoveryState.RECOVERED, 1, 345)));
        IMAGE1 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(TOPIC_IMAGES1), TopicsImageTest.newTopicsByNameMap(TOPIC_IMAGES1), Collections.emptyMap(), TopicsImageTest.newTopicsByLinkIdMap(TOPIC_IMAGES1));
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(FOO_UUID), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_UUID).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("baz").setTopicId(BAZ_UUID), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(1, 2, 3, 4)).setIsr(Arrays.asList(3, 4)).setRemovingReplicas(Collections.singletonList(2)).setAddingReplicas(Collections.singletonList(1)).setLeader(3).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new MirrorTopicChangeRecord().setTopicId(BAR_UUID).setMirrorTopicState("FailedMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setStoppedLogEndOffsets(Collections.emptyList()), MetadataRecordType.MIRROR_TOPIC_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1 = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        List<TopicImage> topics2 = Arrays.asList(TopicsImageTest.newTopicImage("bar", BAR_UUID, FAILED_MIRROR_TOPIC_STATE, new PartitionRegistration(new int[]{0, 1, 2, 3, 4}, new int[]{0, 1, 2, 3}, new int[]{1}, new int[]{3, 4}, 1, LeaderRecoveryState.RECOVERED, 2, 346)), TopicsImageTest.newTopicImage("baz", BAZ_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration(new int[]{1, 2, 3, 4}, new int[]{3, 4}, new int[]{2}, new int[]{1}, 3, LeaderRecoveryState.RECOVERED, 2, 1)));
        IMAGE2 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics2), TopicsImageTest.newTopicsByNameMap(topics2), Collections.emptyMap(), TopicsImageTest.newTopicsByLinkIdMap(topics2));
    }

    private static class TopicNameToTenant
    implements Function<String, String> {
        static final TopicNameToTenant INSTANCE = new TopicNameToTenant();

        private TopicNameToTenant() {
        }

        @Override
        public String apply(String name) {
            int i = name.indexOf(95);
            return i == -1 ? null : name.substring(0, i + 1);
        }
    }
}

