/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.AclsImageTest;
import org.apache.kafka.image.BrokerReplicaExclusionsImageTest;
import org.apache.kafka.image.ClientQuotasImageTest;
import org.apache.kafka.image.ClusterImageTest;
import org.apache.kafka.image.ClusterLinksImageTest;
import org.apache.kafka.image.ConfigurationsImageTest;
import org.apache.kafka.image.FeaturesImageTest;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MockSnapshotConsumer;
import org.apache.kafka.image.ProducerIdsImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImageTest;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MetadataImageTest {
    public static final MetadataImage IMAGE1;
    public static final MetadataDelta DELTA1;
    public static final MetadataImage IMAGE2;
    public static final KafkaConfigSchema CONFIG_SCHEMA;
    public static final Uuid ENCRYPTOR_UUID;
    public static final MetadataEncryptor ENCRYPTOR;
    public static final MetadataEncryptorFactory ENCRYPTOR_FACTORY;

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(MetadataImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    @Test
    public void testRemoveClusterLink() {
        MetadataDelta delta = new MetadataDelta(IMAGE1, __ -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
        List<ApiMessageAndVersion> records = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("doesn't matter"), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        RecordTestUtils.replayAll(delta, records);
        Assertions.assertTrue((boolean)IMAGE1.clusterLinks().linksById().containsKey(ClusterLinksImageTest.LINK_FOO_UUID));
        List topicsWithLink = IMAGE1.topics().topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID);
        Assertions.assertFalse((boolean)topicsWithLink.isEmpty());
        for (TopicImage image : topicsWithLink) {
            Assertions.assertTrue((boolean)image.mirrorTopic().isPresent());
            Assertions.assertEquals((Object)ClusterLinksImageTest.LINK_FOO_UUID, (Object)((MirrorTopic)image.mirrorTopic().get()).linkId());
        }
        MetadataImage image = delta.apply();
        Assertions.assertNull(image.clusterLinks().linksById().get(ClusterLinksImageTest.LINK_FOO_UUID), (String)"Should not have this cluster link after removal");
        Assertions.assertTrue((boolean)image.topics().topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty(), (String)"Expect zero topics to be using the removed link");
        for (TopicImage topicImage : topicsWithLink) {
            Assertions.assertFalse((boolean)image.topics().getTopic(topicImage.id()).mirrorTopic().isPresent(), (String)"Expected topic to have no mirror state");
        }
    }

    private void testToImageAndBack(MetadataImage image) throws Throwable {
        MockSnapshotConsumer writer = new MockSnapshotConsumer();
        image.write((Consumer)writer, CONFIG_SCHEMA);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY.copyWithEncryptor(image.encryptor()), __ -> null, ENCRYPTOR_FACTORY);
        RecordTestUtils.replayAllBatches(delta, image.highestOffsetAndEpoch().offset, image.highestOffsetAndEpoch().epoch, writer.batches());
        MetadataImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    @Test
    public void testImage1WithEncryptionRoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1.copyWithEncryptor(ENCRYPTOR));
    }

    @Test
    public void testImage2WithEncryptionRoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2.copyWithEncryptor(ENCRYPTOR));
    }

    static {
        CONFIG_SCHEMA = KafkaConfigSchema.EMPTY;
        IMAGE1 = new MetadataImage(new OffsetAndEpoch(100L, 4), FeaturesImageTest.IMAGE1, ClusterImageTest.IMAGE1, TopicsImageTest.IMAGE1, ConfigurationsImageTest.IMAGE1, ClientQuotasImageTest.IMAGE1, ProducerIdsImageTest.IMAGE1, AclsImageTest.IMAGE1, ClusterLinksImageTest.IMAGE1, BrokerReplicaExclusionsImageTest.IMAGE1, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        DELTA1 = new MetadataDelta(IMAGE1, __ -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
        RecordTestUtils.replayAll(DELTA1, 200L, 5, FeaturesImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, ClusterImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, TopicsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, ConfigurationsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, ClientQuotasImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, ProducerIdsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, AclsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, ClusterLinksImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, 200L, 5, BrokerReplicaExclusionsImageTest.DELTA1_RECORDS);
        IMAGE2 = new MetadataImage(new OffsetAndEpoch(200L, 5), FeaturesImageTest.IMAGE2, ClusterImageTest.IMAGE2, TopicsImageTest.IMAGE2, ConfigurationsImageTest.IMAGE2, ClientQuotasImageTest.IMAGE2, ProducerIdsImageTest.IMAGE2, AclsImageTest.IMAGE2, ClusterLinksImageTest.IMAGE2, BrokerReplicaExclusionsImageTest.IMAGE2, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        ENCRYPTOR_UUID = Uuid.fromString((String)"nNr41iuoQTOiKXl8DT8lIg");
        try {
            byte[] secret = new byte[16];
            for (int i = 0; i < secret.length; ++i) {
                secret[i] = (byte)(i + 10);
            }
            ENCRYPTOR = new AesGcm128MetadataEncryptor(ENCRYPTOR_UUID, secret);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> factoryConfig = new HashMap<String, String>();
        factoryConfig.put("confluent.metadata.active.encryptor", ENCRYPTOR_UUID.toString());
        factoryConfig.put("confluent.metadata.encryptor.classes", ENCRYPTOR_UUID.toString() + "=" + AesGcm128MetadataEncryptor.class.getCanonicalName());
        factoryConfig.put("confluent.metadata.encryptor.secrets", ENCRYPTOR_UUID.toString() + "=" + Base64.getUrlEncoder().withoutPadding().encodeToString(ENCRYPTOR.secret()));
        ENCRYPTOR_FACTORY = new MetadataEncryptorFactory(factoryConfig);
    }
}

