/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationsDeltaTest {
    @Test
    public void testGetChanges() {
        ConfigurationsDelta delta = this.setupDelta();
        ConfigResource searchResource = new ConfigResource(ConfigResource.Type.TOPIC, "");
        HashSet<String> searchKeys = new HashSet<String>();
        searchKeys.add("bar1");
        searchKeys.add("foo1");
        Map changes = delta.getChangesMatching(searchResource, searchKeys);
        Assertions.assertEquals((int)0, (int)changes.size());
        searchResource = new ConfigResource(ConfigResource.Type.BROKER, "ID1");
        searchKeys.clear();
        searchKeys.add("baz1");
        searchKeys.add("baz2");
        changes = delta.getChangesMatching(searchResource, searchKeys);
        Assertions.assertEquals((int)0, (int)changes.size());
        searchResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        searchKeys.clear();
        searchKeys.add("foo1");
        searchKeys.add("foo2");
        searchKeys.add("baz1");
        searchKeys.add("baz2");
        changes = delta.getChangesMatching(searchResource, searchKeys);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("baz1", "baz2")), changes.keySet());
        Assertions.assertTrue((boolean)changes.values().containsAll(Arrays.asList("b1", "b2")));
    }

    private ConfigurationsDelta setupDelta() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("foo1", "f1");
        configs.put("foo2", "f2");
        configs.put("foo3", "f3");
        configs.put("foo4", "f4");
        configs.put("foo5", "f5");
        configs.put("foo6", "f6");
        ConfigurationImage configImage = new ConfigurationImage(configs);
        HashMap<ConfigResource, ConfigurationImage> data = new HashMap<ConfigResource, ConfigurationImage>();
        data.put(new ConfigResource(ConfigResource.Type.BROKER, ""), configImage);
        data.put(new ConfigResource(ConfigResource.Type.BROKER, "ID1"), configImage);
        data.put(new ConfigResource(ConfigResource.Type.UNKNOWN, ""), configImage);
        ConfigurationsImage baseImage = new ConfigurationsImage(data);
        ConfigurationsDelta delta = new ConfigurationsDelta(baseImage);
        ConfigRecord record1 = new ConfigRecord();
        ConfigRecord record2 = new ConfigRecord();
        ConfigRecord record3 = new ConfigRecord();
        ConfigRecord record4 = new ConfigRecord();
        ConfigRecord record5 = new ConfigRecord();
        ConfigRecord record6 = new ConfigRecord();
        record1.setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setName("baz1").setValue("b1");
        record2.setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setName("baz2").setValue("b2");
        record3.setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setName("baz3").setValue("b3");
        record4.setResourceName("").setResourceType(ConfigResource.Type.TOPIC.id()).setName("baz1").setValue("bt1");
        record5.setResourceName("").setResourceType(ConfigResource.Type.TOPIC.id()).setName("baz4").setValue("bt4");
        record6.setResourceName("").setResourceType(ConfigResource.Type.UNKNOWN.id()).setName("baz1").setValue("bu4");
        delta.replay(record1);
        delta.replay(record2);
        delta.replay(record3);
        delta.replay(record4);
        delta.replay(record5);
        delta.replay(record6);
        return delta;
    }
}

