/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.BrokerReplicaExclusionsDelta;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.MockSnapshotConsumer;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerReplicaExclusionsImageTest {
    static final BrokerReplicaExclusionsImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final BrokerReplicaExclusionsImage IMAGE2;
    static final BrokerReplicaExclusionsDelta DELTA1;

    @Test
    public void testEmptyImageRoundTrip() {
        this.testToImageAndBack(BrokerReplicaExclusionsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(BrokerReplicaExclusionsImage image) {
        MockSnapshotConsumer writer = new MockSnapshotConsumer();
        image.write((Consumer)writer);
        BrokerReplicaExclusionsDelta delta = new BrokerReplicaExclusionsDelta(BrokerReplicaExclusionsImage.EMPTY);
        RecordTestUtils.replayAllBatches(delta, writer.batches());
        BrokerReplicaExclusionsImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    private static ApiMessageAndVersion record(Map<Integer, String> exclusions) {
        return new ApiMessageAndVersion((ApiMessage)new BrokerReplicaExclusionRecord().setBrokerExclusions(BrokerReplicaExclusionsImageTest.recordExclusions(exclusions)), MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD.highestSupportedVersion());
    }

    private static List<BrokerReplicaExclusionRecord.BrokerReplicaExclusion> recordExclusions(Map<Integer, String> exclusions) {
        return exclusions.entrySet().stream().map(e -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId((Integer)e.getKey()).setReason((String)e.getValue())).collect(Collectors.toList());
    }

    static {
        HashMap<Integer, String> map1 = new HashMap<Integer, String>();
        map1.put(1, "1");
        map1.put(2, "2");
        map1.put(3, "3");
        IMAGE1 = new BrokerReplicaExclusionsImage(map1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.put(4, "4");
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.put(5, "5");
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.remove(2);
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.remove(1);
        map1.remove(3);
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        DELTA1 = new BrokerReplicaExclusionsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<Integer, String> finalMap = new HashMap<Integer, String>();
        finalMap.put(4, "4");
        finalMap.put(5, "5");
        IMAGE2 = new BrokerReplicaExclusionsImage(finalMap);
    }
}

