/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.image.AclsDelta;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class AclsDeltaTest {
    private Uuid aclId = Uuid.fromString((String)"iOZpss6VQUmD6blnqzl50g");

    @Test
    public void testRemovesDeleteIfNotInImage() {
        AclsImage image = new AclsImage(Collections.emptyMap());
        AclsDelta delta = new AclsDelta(image);
        AccessControlEntryRecord inputAclRecord = this.testAccessControlEntryRecord();
        Assertions.assertEquals((int)0, (int)delta.changes().size());
        delta.replay(inputAclRecord);
        Assertions.assertEquals(Optional.of(this.testStandardAcl()), delta.changes().get(this.aclId));
        RemoveAccessControlEntryRecord inputRemoveAclRecord = this.testRemoveAccessControlEntryRecord();
        delta.replay(inputRemoveAclRecord);
        Assertions.assertFalse((boolean)delta.changes().containsKey(this.aclId));
    }

    @Test
    public void testKeepsDeleteIfInImage() {
        HashMap<Uuid, ConfluentStandardAcl> initialImageMap = new HashMap<Uuid, ConfluentStandardAcl>();
        initialImageMap.put(this.aclId, this.testStandardAcl());
        AclsImage image = new AclsImage(initialImageMap);
        AclsDelta delta = new AclsDelta(image);
        Assertions.assertEquals((int)0, (int)delta.changes().size());
        RemoveAccessControlEntryRecord removeAccessControlEntryRecord = this.testRemoveAccessControlEntryRecord();
        delta.replay(removeAccessControlEntryRecord);
        Assertions.assertTrue((boolean)delta.changes().containsKey(this.aclId));
        Assertions.assertEquals(Optional.empty(), delta.changes().get(this.aclId));
    }

    @Test
    public void testThrowsExceptionOnInvalidStateWhenImageIsEmpty() {
        AclsImage image = new AclsImage(Collections.emptyMap());
        AclsDelta delta = new AclsDelta(image);
        RemoveAccessControlEntryRecord removeAccessControlEntryRecord = this.testRemoveAccessControlEntryRecord();
        Assertions.assertThrows(IllegalStateException.class, () -> delta.replay(removeAccessControlEntryRecord));
    }

    @Test
    public void testThrowsExceptionOnInvalidStateWhenImageHasOtherAcls() {
        Uuid id = Uuid.fromString((String)"nGiNMQHwRgmgsIlfu73aJQ");
        AccessControlEntryRecord record = new AccessControlEntryRecord();
        record.setId(id);
        record.setResourceType((byte)1);
        record.setResourceName("foo");
        record.setPatternType((byte)1);
        record.setPrincipal("User:user");
        record.setHost("host");
        record.setOperation((byte)1);
        record.setPermissionType((byte)1);
        HashMap<Uuid, ConfluentStandardAcl> initialImageMap = new HashMap<Uuid, ConfluentStandardAcl>();
        initialImageMap.put(id, ConfluentStandardAcl.fromRecord((AccessControlEntryRecord)record));
        AclsImage image = new AclsImage(initialImageMap);
        AclsDelta delta = new AclsDelta(image);
        RemoveAccessControlEntryRecord removeAccessControlEntryRecord = this.testRemoveAccessControlEntryRecord();
        Assertions.assertThrows(IllegalStateException.class, () -> delta.replay(removeAccessControlEntryRecord));
    }

    private AccessControlEntryRecord testAccessControlEntryRecord() {
        AccessControlEntryRecord record = new AccessControlEntryRecord();
        record.setId(this.aclId);
        record.setResourceType((byte)1);
        record.setResourceName("foo");
        record.setPatternType((byte)1);
        record.setPrincipal("User:user");
        record.setHost("host");
        record.setOperation((byte)1);
        record.setPermissionType((byte)1);
        return record;
    }

    private RemoveAccessControlEntryRecord testRemoveAccessControlEntryRecord() {
        RemoveAccessControlEntryRecord record = new RemoveAccessControlEntryRecord();
        record.setId(this.aclId);
        return record;
    }

    private ConfluentStandardAcl testStandardAcl() {
        return ConfluentStandardAcl.fromRecord((AccessControlEntryRecord)this.testAccessControlEntryRecord());
    }
}

