/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.MockControllerMetrics;
import org.apache.kafka.controller.ProducerIdControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProducerIdControlManagerTest {
    private SnapshotRegistry snapshotRegistry;
    private FeatureControlManager featureControl;
    private ClusterControlManager clusterControl;
    private ProducerIdControlManager producerIdControlManager;

    @BeforeEach
    public void setUp() {
        MockTime time = new MockTime();
        this.snapshotRegistry = new SnapshotRegistry(new LogContext());
        this.featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        this.clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(this.snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(this.featureControl).build();
        this.clusterControl.activate();
        for (int i = 0; i < 4; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i);
            brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost(String.format("broker-%02d.example.org", i)));
            this.clusterControl.replay(brokerRecord, 100L);
        }
        this.producerIdControlManager = new ProducerIdControlManager(this.clusterControl, this.snapshotRegistry);
    }

    @Test
    public void testInitialResult() {
        ControllerResult result = this.producerIdControlManager.generateNextProducerId(1, 100L);
        Assertions.assertEquals((long)0L, (long)((ProducerIdsBlock)result.response()).firstProducerId());
        Assertions.assertEquals((int)1000, (int)((ProducerIdsBlock)result.response()).size());
        ProducerIdsRecord record = (ProducerIdsRecord)((ApiMessageAndVersion)result.records().get(0)).message();
        Assertions.assertEquals((long)1000L, (long)record.nextProducerId());
    }

    @Test
    public void testMonotonic() {
        this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(42L));
        ProducerIdsBlock range = (ProducerIdsBlock)this.producerIdControlManager.generateNextProducerId(1, 100L).response();
        Assertions.assertEquals((long)42L, (long)range.firstProducerId());
        Assertions.assertThrows(RuntimeException.class, () -> this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(40L)), (String)"Producer ID range must only increase");
        range = (ProducerIdsBlock)this.producerIdControlManager.generateNextProducerId(1, 100L).response();
        Assertions.assertEquals((long)42L, (long)range.firstProducerId());
        this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(50L));
        range = (ProducerIdsBlock)this.producerIdControlManager.generateNextProducerId(1, 100L).response();
        Assertions.assertEquals((long)50L, (long)range.firstProducerId());
    }

    @Test
    public void testUnknownBrokerOrEpoch() {
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.producerIdControlManager.generateNextProducerId(99, 0L));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.producerIdControlManager.generateNextProducerId(1, 99L));
    }

    @Test
    public void testMaxValue() {
        this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(0x7FFFFFFFFFFFFFFEL));
        Assertions.assertThrows(UnknownServerException.class, () -> this.producerIdControlManager.generateNextProducerId(1, 100L));
    }

    @Test
    public void testSnapshotIterator() {
        ProducerIdsBlock range = null;
        for (int i = 0; i < 100; ++i) {
            range = ProducerIdControlManagerTest.generateProducerIds(this.producerIdControlManager, i % 4, 100L);
        }
        Iterator snapshotIterator = this.producerIdControlManager.iterator(Long.MAX_VALUE);
        Assertions.assertTrue((boolean)snapshotIterator.hasNext());
        List batch = (List)snapshotIterator.next();
        Assertions.assertEquals((int)1, (int)batch.size(), (String)"Producer IDs record batch should only contain a single record");
        Assertions.assertEquals((long)(range.firstProducerId() + (long)range.size()), (long)((ProducerIdsRecord)((ApiMessageAndVersion)batch.get(0)).message()).nextProducerId());
        Assertions.assertFalse((boolean)snapshotIterator.hasNext(), (String)"Producer IDs iterator should only contain a single batch");
        ProducerIdControlManager newProducerIdManager = new ProducerIdControlManager(this.clusterControl, this.snapshotRegistry);
        snapshotIterator = this.producerIdControlManager.iterator(Long.MAX_VALUE);
        while (snapshotIterator.hasNext()) {
            ((List)snapshotIterator.next()).forEach(message -> newProducerIdManager.replay((ProducerIdsRecord)message.message()));
        }
        long lastProducerID = range.firstProducerId() + (long)range.size() - 1L;
        range = ProducerIdControlManagerTest.generateProducerIds(this.producerIdControlManager, 1, 100L);
        Assertions.assertTrue((range.firstProducerId() > lastProducerID ? 1 : 0) != 0);
    }

    static ProducerIdsBlock generateProducerIds(ProducerIdControlManager producerIdControlManager, int brokerId, long brokerEpoch) {
        ControllerResult result = producerIdControlManager.generateNextProducerId(brokerId, brokerEpoch);
        result.records().forEach(apiMessageAndVersion -> producerIdControlManager.replay((ProducerIdsRecord)apiMessageAndVersion.message()));
        return (ProducerIdsBlock)result.response();
    }
}

