/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentReplicasTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Arrays.asList(3, 2, 1), Arrays.asList(3, 2, 1));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)replicas.merged());
    }

    @Test
    public void testAdditions() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Arrays.asList(3, 2, 1), Arrays.asList(3, 6, 2, 1, 5));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(5, 6), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 6, 2, 1, 5), (Object)replicas.merged());
    }

    @Test
    public void testRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Arrays.asList(3, 2, 1, 0), Arrays.asList(3, 1));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 1, 0, 2), (Object)replicas.merged());
    }

    @Test
    public void testAdditionsAndRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Arrays.asList(3, 2, 1, 0), Arrays.asList(7, 3, 1, 9));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(7, 9), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(7, 3, 1, 9, 0, 2), (Object)replicas.merged());
    }

    @Test
    public void testRearrangement() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Arrays.asList(3, 2, 1, 0), Arrays.asList(0, 1, 3, 2));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(0, 1, 3, 2), (Object)replicas.merged());
    }
}

