/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.controller.ControllerMetrics;

public final class MockControllerMetrics
implements ControllerMetrics {
    private volatile boolean active = false;
    private volatile int fencedBrokers = 0;
    private volatile int activeBrokers = 0;
    private volatile int topics = 0;
    private volatile int partitions = 0;
    private volatile int offlinePartitions = 0;
    private volatile int preferredReplicaImbalances = 0;
    private volatile AtomicInteger metadataErrors = new AtomicInteger(0);
    private volatile long lastAppliedRecordOffset = 0L;
    private volatile long lastCommittedRecordOffset = 0L;
    private volatile long lastAppliedRecordTimestamp = 0L;
    private volatile boolean closed = false;
    private volatile long lastControllerLoadMs = -1L;

    public void recordControllerLoadTime(long startMs, long endMs) {
        this.lastControllerLoadMs = endMs - startMs;
    }

    public long lastControllerLoadMs() {
        return this.lastControllerLoadMs;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean active() {
        return this.active;
    }

    public void updateEventQueueTime(long durationMs) {
    }

    public void updateEventQueueProcessingTime(long durationMs) {
    }

    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokers = brokerCount;
    }

    public int fencedBrokerCount() {
        return this.fencedBrokers;
    }

    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokers = brokerCount;
    }

    public int activeBrokerCount() {
        return this.activeBrokers;
    }

    public void setGlobalTopicsCount(int topicCount) {
        this.topics = topicCount;
    }

    public int globalTopicsCount() {
        return this.topics;
    }

    public void setGlobalPartitionCount(int partitionCount) {
        this.partitions = partitionCount;
    }

    public int globalPartitionCount() {
        return this.partitions;
    }

    public void setOfflinePartitionCount(int offlinePartitions) {
        this.offlinePartitions = offlinePartitions;
    }

    public int offlinePartitionCount() {
        return this.offlinePartitions;
    }

    public void setPreferredReplicaImbalanceCount(int replicaImbalances) {
        this.preferredReplicaImbalances = replicaImbalances;
    }

    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalances;
    }

    public void incrementMetadataErrorCount() {
        this.metadataErrors.getAndIncrement();
    }

    public int metadataErrorCount() {
        return this.metadataErrors.get();
    }

    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset = offset;
    }

    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset;
    }

    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset = offset;
    }

    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset;
    }

    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp = timestamp;
    }

    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

