/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.EncryptionControlManager;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactoryTest;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class EncryptionControlManagerTest {
    @Test
    public void testEncryptionControlManagerWithoutConfig() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        EncryptionControlManager manager = new EncryptionControlManager(new LogContext(), snapshotRegistry, Collections.emptyMap());
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)manager.encryptorId());
        Assertions.assertEquals(NoOpMetadataEncryptor.class, manager.encryptor().getClass());
        ControllerResult result = manager.maybeInstallEncryptor();
        Assertions.assertEquals(Collections.emptyList(), (Object)result.records());
        EncryptionControlManager.EncryptionControlIterator iterator = manager.iterator(Long.MAX_VALUE);
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(Uuid.ZERO_UUID), 0)), (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEncryptionControlManagerWithConfiguredEncryptor() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        snapshotRegistry.getOrCreateSnapshot(0L);
        EncryptionControlManager manager = new EncryptionControlManager(new LogContext(), snapshotRegistry, MetadataEncryptorFactoryTest.TEST_CONFIG);
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)manager.encryptorId());
        Assertions.assertEquals(NoOpMetadataEncryptor.class, manager.encryptor().getClass());
        ControllerResult result = manager.maybeInstallEncryptor();
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(MetadataEncryptorFactoryTest.FOO_ID), 0)), (Object)result.records());
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)MetadataEncryptorFactoryTest.FOO_ID, (Object)manager.encryptorId());
        Assertions.assertEquals(AesGcm128MetadataEncryptor.class, manager.encryptor().getClass());
        snapshotRegistry.getOrCreateSnapshot(1L);
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(Uuid.ZERO_UUID), 0)), (Object)manager.iterator(0L).next());
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(MetadataEncryptorFactoryTest.FOO_ID), 0)), (Object)manager.iterator(1L).next());
    }
}

