/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.EncryptionControlManager;
import org.apache.kafka.metadata.ConfigSynonym;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptorFactoryTest;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationControlManagerTest {
    static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();
    public static final Map<String, List<ConfigSynonym>> SYNONYMS;
    static final KafkaConfigSchema SCHEMA;
    static final ConfigResource BROKER0;
    static final ConfigResource MYTOPIC;

    private static <A, B> Map<A, B> toMap(Map.Entry ... entries) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static <A, B> Map.Entry<A, B> entry(A a, B b) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(a, b);
    }

    @Test
    public void testReplay() throws Exception {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).build();
        Assertions.assertEquals(Collections.emptyMap(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue("1,2"));
        Assertions.assertEquals(Collections.singletonMap("foo.bar", "1,2"), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue(null));
        Assertions.assertEquals(Collections.emptyMap(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("x,y,z"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("blah"));
        Assertions.assertEquals(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "x,y,z"), ConfigurationControlManagerTest.entry("def", "blah")), (Object)manager.getConfigs(MYTOPIC));
        RecordTestUtils.assertBatchIteratorContains(Arrays.asList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("x,y,z"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("blah"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()))), (Iterator<List<ApiMessageAndVersion>>)manager.iterator(Long.MAX_VALUE));
    }

    @Test
    public void testIncrementalAlterConfigs() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).build();
        ControllerResult result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("baz", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SUBTRACT, "abc")), ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "abc")))), ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123"))))), true, KafkaPrincipal.ANONYMOUS);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("123"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, new ApiError(Errors.INVALID_CONFIG, "Can't SUBTRACT to key baz because its type is not LIST.")), ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, "xyz"))))), true, KafkaPrincipal.ANONYMOUS));
    }

    @Test
    public void testIncrementalAlterMultipleConfigValues() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).build();
        ControllerResult result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123,456,789"))))), true, KafkaPrincipal.ANONYMOUS);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("123,456,789"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123,456"))))), true, KafkaPrincipal.ANONYMOUS);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SUBTRACT, "123,456"))))), true, KafkaPrincipal.ANONYMOUS);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("789"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SUBTRACT, "123456"))))), true, KafkaPrincipal.ANONYMOUS);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)"789", manager.getConfigs(MYTOPIC).get("abc"));
    }

    @Test
    public void testIncrementalAlterConfigsWithoutExistence() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).setExistenceChecker((Consumer)TestExistenceChecker.INSTANCE).build();
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, "ExistingTopic");
        ControllerResult result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "1")))), ConfigurationControlManagerTest.entry(existingTopic, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("def", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "newVal"))))), false, KafkaPrincipal.ANONYMOUS);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("ExistingTopic").setName("def").setValue("newVal"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "Unknown resource.")), ConfigurationControlManagerTest.entry(existingTopic, ApiError.NONE))), (Object)result);
    }

    @Test
    public void testIncrementalAlterConfigsWithPolicy() {
        MockAlterConfigsPolicy policy = new MockAlterConfigsPolicy(Arrays.asList(new AlterConfigPolicy.RequestMetadata(MYTOPIC, Collections.emptyMap(), KafkaPrincipal.ANONYMOUS), new AlterConfigPolicy.RequestMetadata(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", "123"), ConfigurationControlManagerTest.entry("quux", "456"), ConfigurationControlManagerTest.entry("broker.config.to.remove", null)), KafkaPrincipal.ANONYMOUS)));
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).setAlterConfigPolicy(Optional.of(policy)).build();
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("broker.config").setValue("123"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(MYTOPIC.name()).setName("topic.config").setValue("123"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("broker.config.to.remove").setValue("123"));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue("123"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("quux").setValue("456"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("broker.config.to.remove").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, new ApiError(Errors.POLICY_VIOLATION, "Expected: AlterConfigPolicy.RequestMetadata(resource=ConfigResource(type=TOPIC, name='mytopic'), configs={}, principal=User:ANONYMOUS). Got: AlterConfigPolicy.RequestMetadata(resource=ConfigResource(type=TOPIC, name='mytopic'), configs={foo.bar=123}, principal=User:ANONYMOUS)")), ConfigurationControlManagerTest.entry(BROKER0, ApiError.NONE))), (Object)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123")))), ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123")), ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "456")), ConfigurationControlManagerTest.entry("broker.config.to.remove", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, null))))), true, KafkaPrincipal.ANONYMOUS));
    }

    @Test
    public void testLegacyAlterConfigs() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).setAlterConfigPolicy(Optional.of(new CheckForNullValuesPolicy())).build();
        List<ApiMessageAndVersion> expectedRecords1 = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("456"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("901"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(expectedRecords1, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "456"), ConfigurationControlManagerTest.entry("def", "901")))), true));
        for (ApiMessageAndVersion message : expectedRecords1) {
            manager.replay((ConfigRecord)message.message());
        }
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("def", "901")))), true));
    }

    @Test
    public void testCreateEncryptedConfigRecords() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        EncryptionControlManager encryptionControl = new EncryptionControlManager(new LogContext(), snapshotRegistry, MetadataEncryptorFactoryTest.TEST_CONFIG);
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).setEncryptionControlManager(encryptionControl).setExistenceChecker((Consumer)TestExistenceChecker.INSTANCE).build();
        this.checkIfOutputIsEncrypted(false, manager, "xyz");
        snapshotRegistry.getOrCreateSnapshot(100L);
        RecordTestUtils.replayAll(encryptionControl, encryptionControl.maybeInstallEncryptor().records());
        this.checkIfOutputIsEncrypted(true, manager, "xyz");
        this.checkIfOutputIsEncrypted(false, manager, "def");
        this.checkIfOutputIsEncrypted(true, manager, "unknownkey");
        snapshotRegistry.revertToSnapshot(100L);
        this.checkIfOutputIsEncrypted(false, manager, "xyz");
    }

    private void checkIfOutputIsEncrypted(boolean expectedEncrypted, ConfigurationControlManager manager, String entryName) {
        this.checkIfOutputIsEncrypted(expectedEncrypted, manager, (ControllerResult<Map<ConfigResource, ApiError>>)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(entryName, ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123"))))), true, KafkaPrincipal.ANONYMOUS), entryName);
        this.checkIfOutputIsEncrypted(expectedEncrypted, manager, (ControllerResult<Map<ConfigResource, ApiError>>)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(entryName, "123")))), true, KafkaPrincipal.ANONYMOUS), entryName);
    }

    private void checkIfOutputIsEncrypted(boolean expectedEncrypted, ConfigurationControlManager manager, ControllerResult<Map<ConfigResource, ApiError>> result, String entryName) {
        Assertions.assertEquals(Collections.singletonMap(MYTOPIC, ApiError.NONE), (Object)result.response());
        Assertions.assertEquals((int)1, (int)result.records().size());
        ConfigRecord configRecord = null;
        if (expectedEncrypted) {
            Assertions.assertEquals(EncryptedEnvelopeRecord.class, ((ApiMessageAndVersion)result.records().get(0)).message().getClass());
            ApiMessageAndVersion messageAndVersion = manager.encryptionControl().encryptor().decrypt((EncryptedEnvelopeRecord)((ApiMessageAndVersion)result.records().get(0)).message());
            configRecord = (ConfigRecord)messageAndVersion.message();
        } else {
            Assertions.assertEquals(ConfigRecord.class, ((ApiMessageAndVersion)result.records().get(0)).message().getClass());
            configRecord = (ConfigRecord)((ApiMessageAndVersion)result.records().get(0)).message();
        }
        Assertions.assertEquals((Object)MYTOPIC.name(), (Object)configRecord.resourceName());
        Assertions.assertEquals((byte)ConfigResource.Type.TOPIC.id(), (byte)configRecord.resourceType());
        Assertions.assertEquals((Object)entryName, (Object)configRecord.name());
        Assertions.assertEquals((Object)"123", (Object)configRecord.value());
    }

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("foo.bar", ConfigDef.Type.LIST, (Object)"1", ConfigDef.Importance.HIGH, "foo bar").define("baz", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("quux", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "quux"));
        CONFIGS.put(ConfigResource.Type.TOPIC, new ConfigDef().define("abc", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "abc").define("def", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "def").define("ghi", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, "ghi").define("quuux", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "quux").define("xyz", ConfigDef.Type.PASSWORD, (Object)"default_xyz", ConfigDef.Importance.HIGH, "xyz"));
        SYNONYMS = new HashMap<String, List<ConfigSynonym>>();
        SYNONYMS.put("abc", Arrays.asList(new ConfigSynonym("foo.bar")));
        SYNONYMS.put("def", Arrays.asList(new ConfigSynonym("baz")));
        SYNONYMS.put("quuux", Arrays.asList(new ConfigSynonym("quux", ConfigSynonym.HOURS_TO_MILLISECONDS)));
        SCHEMA = new KafkaConfigSchema(CONFIGS, SYNONYMS);
        BROKER0 = new ConfigResource(ConfigResource.Type.BROKER, "0");
        MYTOPIC = new ConfigResource(ConfigResource.Type.TOPIC, "mytopic");
    }

    private static class CheckForNullValuesPolicy
    implements AlterConfigPolicy {
        private CheckForNullValuesPolicy() {
        }

        public void validate(AlterConfigPolicy.RequestMetadata actual) throws PolicyViolationException {
            actual.configs().forEach((key, value) -> {
                if (value == null) {
                    throw new PolicyViolationException("Legacy Alter Configs should not see null values");
                }
            });
        }

        public void close() throws Exception {
        }

        public void configure(Map<String, ?> configs) {
        }
    }

    private static class MockAlterConfigsPolicy
    implements AlterConfigPolicy {
        private final List<AlterConfigPolicy.RequestMetadata> expecteds;
        private final AtomicLong index = new AtomicLong(0L);

        MockAlterConfigsPolicy(List<AlterConfigPolicy.RequestMetadata> expecteds) {
            this.expecteds = expecteds;
        }

        public void validate(AlterConfigPolicy.RequestMetadata actual) throws PolicyViolationException {
            long curIndex = this.index.getAndIncrement();
            if (curIndex >= (long)this.expecteds.size()) {
                throw new PolicyViolationException("Unexpected config alteration: index out of range at " + curIndex);
            }
            AlterConfigPolicy.RequestMetadata expected = this.expecteds.get((int)curIndex);
            if (!expected.equals((Object)actual)) {
                throw new PolicyViolationException("Expected: " + expected + ". Got: " + actual);
            }
        }

        public void close() throws Exception {
        }

        public void configure(Map<String, ?> configs) {
        }
    }

    static class TestExistenceChecker
    implements Consumer<ConfigResource> {
        static final TestExistenceChecker INSTANCE = new TestExistenceChecker();

        TestExistenceChecker() {
        }

        @Override
        public void accept(ConfigResource resource) {
            if (!resource.name().startsWith("Existing")) {
                throw new UnknownTopicOrPartitionException("Unknown resource.");
            }
        }
    }
}

