/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.AclControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.metadata.authorizer.StandardAclWithIdTest;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class AclControlManagerTest {
    @Test
    public void testValidateNewAcl() {
        AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW)));
        Assertions.assertEquals((Object)"Invalid patternType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.UNKNOWN), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid resourceType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.UNKNOWN, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid operation UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.UNKNOWN, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid permissionType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.UNKNOWN))))).getMessage());
    }

    @Test
    public void testValidateFilter() {
        AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.LITERAL), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.ANY)));
        Assertions.assertEquals((Object)"Unknown patternFilter.", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.UNKNOWN), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.ANY))))).getMessage());
        Assertions.assertEquals((Object)"Unknown entryFilter.", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.MATCH), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.UNKNOWN))))).getMessage());
    }

    @Test
    public void testLoadSnapshot() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        snapshotRegistry.getOrCreateSnapshot(0L);
        AclControlManager manager = new AclControlManager(snapshotRegistry, Optional.empty());
        HashSet<ApiMessageAndVersion> loadedAcls = new HashSet<ApiMessageAndVersion>();
        for (StandardAclWithId acl : StandardAclWithIdTest.TEST_ACLS) {
            AccessControlEntryRecord record = acl.toRecord();
            Assertions.assertTrue((boolean)loadedAcls.add(new ApiMessageAndVersion((ApiMessage)record, 0)));
            manager.replay(acl.toRecord(), Optional.empty());
        }
        HashSet<ApiMessageAndVersion> foundAcls = new HashSet<ApiMessageAndVersion>();
        Iterator iterator = manager.iterator(Long.MAX_VALUE);
        while (iterator.hasNext()) {
            for (ApiMessageAndVersion apiMessageAndVersion : (List)iterator.next()) {
                Assertions.assertTrue((boolean)foundAcls.add(apiMessageAndVersion));
            }
        }
        Assertions.assertEquals(loadedAcls, foundAcls);
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        Assertions.assertEquals(new HashSet(StandardAclWithIdTest.TEST_ACLS.stream().map(x -> x.acl()).collect(Collectors.toList())), new HashSet<ConfluentStandardAcl>(authorizer.acls.values()));
        snapshotRegistry.revertToSnapshot(0L);
        authorizer.loadSnapshot(manager.idToAcl());
        Assertions.assertFalse((boolean)manager.iterator(Long.MAX_VALUE).hasNext());
    }

    @Test
    public void testAddAndDelete() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        AclControlManager manager = new AclControlManager(snapshotRegistry, Optional.empty());
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        manager.replay(StandardAclWithIdTest.TEST_ACLS.get(0).toRecord(), Optional.empty());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)StandardAclWithIdTest.TEST_ACLS.get(0).toRecord(), 0), ((List)manager.iterator(Long.MAX_VALUE).next()).get(0));
        manager.replay(new RemoveAccessControlEntryRecord().setId(StandardAclWithIdTest.TEST_ACLS.get(0).id()), Optional.empty());
        Assertions.assertFalse((boolean)manager.iterator(Long.MAX_VALUE).hasNext());
    }

    @Test
    public void testCreateAclDeleteAcl() {
        int i;
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        AclControlManager manager = new AclControlManager(snapshotRegistry, Optional.empty());
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        ArrayList<AclBinding> toCreate = new ArrayList<AclBinding>();
        for (int i2 = 0; i2 < 3; ++i2) {
            toCreate.add(StandardAclWithIdTest.TEST_ACLS.get(i2).toBinding());
        }
        toCreate.add(new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.UNKNOWN), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW)));
        ControllerResult createResult = manager.createAcls(toCreate);
        ArrayList<AclCreateResult> expectedResults = new ArrayList<AclCreateResult>();
        for (i = 0; i < 3; ++i) {
            expectedResults.add(AclCreateResult.SUCCESS);
        }
        expectedResults.add(new AclCreateResult((ApiException)new InvalidRequestException("Invalid patternType UNKNOWN")));
        for (i = 0; i < expectedResults.size(); ++i) {
            AclCreateResult expectedResult = (AclCreateResult)expectedResults.get(i);
            if (expectedResult.exception().isPresent()) {
                Assertions.assertEquals((Object)((ApiException)expectedResult.exception().get()).getMessage(), (Object)((ApiException)((AclCreateResult)((List)createResult.response()).get(i)).exception().get()).getMessage());
                continue;
            }
            Assertions.assertFalse((boolean)((AclCreateResult)((List)createResult.response()).get(i)).exception().isPresent());
        }
        RecordTestUtils.replayAll(manager, createResult.records());
        Assertions.assertTrue((boolean)manager.iterator(Long.MAX_VALUE).hasNext());
        ControllerResult deleteResult = manager.deleteAcls(Arrays.asList(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), AccessControlEntryFilter.ANY), new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL), AccessControlEntryFilter.ANY)));
        Assertions.assertEquals((int)2, (int)((List)deleteResult.response()).size());
        HashSet<AclBinding> deleted = new HashSet<AclBinding>();
        for (AclDeleteResult.AclBindingDeleteResult result : ((AclDeleteResult)((List)deleteResult.response()).get(0)).aclBindingDeleteResults()) {
            Assertions.assertEquals(Optional.empty(), (Object)result.exception());
            deleted.add(result.aclBinding());
        }
        Assertions.assertEquals(new HashSet<AclBinding>(Arrays.asList(StandardAclWithIdTest.TEST_ACLS.get(0).toBinding(), StandardAclWithIdTest.TEST_ACLS.get(2).toBinding())), deleted);
        Assertions.assertEquals(InvalidRequestException.class, ((ApiException)((AclDeleteResult)((List)deleteResult.response()).get(1)).exception().get()).getClass());
        RecordTestUtils.replayAll(manager, deleteResult.records());
        Iterator iterator = manager.iterator(Long.MAX_VALUE);
        Assertions.assertTrue((boolean)iterator.hasNext());
        List list = (List)iterator.next();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)StandardAclWithIdTest.TEST_ACLS.get(1).toBinding(), (Object)StandardAcl.fromRecord((AccessControlEntryRecord)((AccessControlEntryRecord)((ApiMessageAndVersion)list.get(0)).message())).toBinding());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCreateMultipleAcls() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        AclControlManager manager = new AclControlManager(snapshotRegistry, Optional.empty());
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        Uuid link1 = Uuid.fromString((String)"R3bMhXGmQNmK46EcBnrAiQ");
        Uuid link2 = Uuid.fromString((String)"1btx_LQcTNmABQKW0MRBVQ");
        ArrayList<Uuid> links = new ArrayList<Uuid>();
        links.add(link1);
        links.add(link2);
        AclBinding aclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW, links));
        ControllerResult createResult = manager.createAcls(Arrays.asList(aclBinding));
        Assertions.assertEquals((int)2, (int)createResult.records().size());
        Assertions.assertEquals((int)1, (int)((List)createResult.response()).size());
        Assertions.assertEquals(Optional.empty(), (Object)((AclCreateResult)((List)createResult.response()).get(0)).exception());
        AccessControlEntryRecord accessControlEntryRecord1 = (AccessControlEntryRecord)((ApiMessageAndVersion)createResult.records().get(0)).message();
        AccessControlEntryRecord accessControlEntryRecord2 = (AccessControlEntryRecord)((ApiMessageAndVersion)createResult.records().get(1)).message();
        Assertions.assertEquals((Object)accessControlEntryRecord1.clusterLinkId(), (Object)link1);
        Assertions.assertEquals((Object)accessControlEntryRecord2.clusterLinkId(), (Object)link2);
    }

    @Test
    public void testDeleteDedupe() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        AclControlManager manager = new AclControlManager(snapshotRegistry, Optional.empty());
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        AclBinding aclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW));
        ControllerResult createResult = manager.createAcls(Arrays.asList(aclBinding));
        Uuid id = ((AccessControlEntryRecord)((ApiMessageAndVersion)createResult.records().get(0)).message()).id();
        Assertions.assertEquals((int)1, (int)createResult.records().size());
        ControllerResult deleteAclResultsAnyFilter = manager.deleteAcls(Arrays.asList(AclBindingFilter.ANY));
        Assertions.assertEquals((int)1, (int)deleteAclResultsAnyFilter.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsAnyFilter.records().get(0)).message()).id());
        Assertions.assertEquals((int)1, (int)((List)deleteAclResultsAnyFilter.response()).size());
        ControllerResult deleteAclResultsSpecificFilter = manager.deleteAcls(Arrays.asList(aclBinding.toFilter()));
        Assertions.assertEquals((int)1, (int)deleteAclResultsSpecificFilter.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsSpecificFilter.records().get(0)).message()).id());
        Assertions.assertEquals((int)1, (int)((List)deleteAclResultsSpecificFilter.response()).size());
        ControllerResult deleteAclResultsBothFilters = manager.deleteAcls(Arrays.asList(AclBindingFilter.ANY, aclBinding.toFilter()));
        Assertions.assertEquals((int)1, (int)deleteAclResultsBothFilters.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsBothFilters.records().get(0)).message()).id());
        Assertions.assertEquals((int)2, (int)((List)deleteAclResultsBothFilters.response()).size());
    }

    static class MockClusterMetadataAuthorizer
    implements ClusterMetadataAuthorizer {
        Map<Uuid, ConfluentStandardAcl> acls = Collections.emptyMap();

        MockClusterMetadataAuthorizer() {
        }

        public void setAclMutator(AclMutator aclMutator) {
        }

        public AclMutator aclMutatorOrException() {
            throw new NotControllerException("The current node is not the active controller.");
        }

        public void completeInitialLoad() {
        }

        public void completeInitialLoad(Exception e) {
        }

        public void loadSnapshot(Map<Uuid, ConfluentStandardAcl> acls) {
            this.acls = acls;
        }

        public void addAcl(Uuid id, ConfluentStandardAcl acl) {
        }

        public void removeAcl(Uuid id) {
        }

        public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return null;
        }

        public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() throws IOException {
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

