/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.AccessControlRecord;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;

public enum MetadataRecordType {
    REGISTER_BROKER_RECORD("RegisterBrokerRecord", 0, 0, 1),
    UNREGISTER_BROKER_RECORD("UnregisterBrokerRecord", 1, 0, 0),
    TOPIC_RECORD("TopicRecord", 2, 0, 0),
    PARTITION_RECORD("PartitionRecord", 3, 0, 0),
    CONFIG_RECORD("ConfigRecord", 4, 0, 0),
    PARTITION_CHANGE_RECORD("PartitionChangeRecord", 5, 0, 0),
    ACCESS_CONTROL_RECORD("AccessControlRecord", 6, 0, 0),
    FENCE_BROKER_RECORD("FenceBrokerRecord", 7, 0, 0),
    UNFENCE_BROKER_RECORD("UnfenceBrokerRecord", 8, 0, 0),
    REMOVE_TOPIC_RECORD("RemoveTopicRecord", 9, 0, 0),
    DELEGATION_TOKEN_RECORD("DelegationTokenRecord", 10, 0, 0),
    USER_SCRAM_CREDENTIAL_RECORD("UserScramCredentialRecord", 11, 0, 0),
    FEATURE_LEVEL_RECORD("FeatureLevelRecord", 12, 0, 0),
    CLIENT_QUOTA_RECORD("ClientQuotaRecord", 14, 0, 0),
    PRODUCER_IDS_RECORD("ProducerIdsRecord", 15, 0, 0),
    BROKER_REGISTRATION_CHANGE_RECORD("BrokerRegistrationChangeRecord", 17, 0, 1),
    ACCESS_CONTROL_ENTRY_RECORD("AccessControlEntryRecord", 18, 0, 0),
    REMOVE_ACCESS_CONTROL_ENTRY_RECORD("RemoveAccessControlEntryRecord", 19, 0, 0),
    NO_OP_RECORD("NoOpRecord", 20, 0, 0),
    CLUSTER_LINK_RECORD("ClusterLinkRecord", 10000, 0, 1),
    MIRROR_TOPIC_RECORD("MirrorTopicRecord", 10001, 0, 0),
    MIRROR_TOPIC_CHANGE_RECORD("MirrorTopicChangeRecord", 10002, 0, 0),
    REMOVE_CLUSTER_LINK_RECORD("RemoveClusterLinkRecord", 10003, 0, 0),
    ENCRYPTED_ENVELOPE_RECORD("EncryptedEnvelopeRecord", 10004, 0, 0),
    INSTALL_METADATA_ENCRYPTOR_RECORD("InstallMetadataEncryptorRecord", 10005, 0, 0),
    BROKER_REPLICA_EXCLUSION_RECORD("BrokerReplicaExclusionRecord", 10015, 0, 0);

    private final String name;
    private final short id;
    private final short lowestSupportedVersion;
    private final short highestSupportedVersion;

    private MetadataRecordType(String name, short id, short lowestSupportedVersion, short highestSupportedVersion) {
        this.name = name;
        this.id = id;
        this.lowestSupportedVersion = lowestSupportedVersion;
        this.highestSupportedVersion = highestSupportedVersion;
    }

    public static MetadataRecordType fromId(short id) {
        switch (id) {
            case 0: {
                return REGISTER_BROKER_RECORD;
            }
            case 1: {
                return UNREGISTER_BROKER_RECORD;
            }
            case 2: {
                return TOPIC_RECORD;
            }
            case 3: {
                return PARTITION_RECORD;
            }
            case 4: {
                return CONFIG_RECORD;
            }
            case 5: {
                return PARTITION_CHANGE_RECORD;
            }
            case 6: {
                return ACCESS_CONTROL_RECORD;
            }
            case 7: {
                return FENCE_BROKER_RECORD;
            }
            case 8: {
                return UNFENCE_BROKER_RECORD;
            }
            case 9: {
                return REMOVE_TOPIC_RECORD;
            }
            case 10: {
                return DELEGATION_TOKEN_RECORD;
            }
            case 11: {
                return USER_SCRAM_CREDENTIAL_RECORD;
            }
            case 12: {
                return FEATURE_LEVEL_RECORD;
            }
            case 14: {
                return CLIENT_QUOTA_RECORD;
            }
            case 15: {
                return PRODUCER_IDS_RECORD;
            }
            case 17: {
                return BROKER_REGISTRATION_CHANGE_RECORD;
            }
            case 18: {
                return ACCESS_CONTROL_ENTRY_RECORD;
            }
            case 19: {
                return REMOVE_ACCESS_CONTROL_ENTRY_RECORD;
            }
            case 20: {
                return NO_OP_RECORD;
            }
            case 10000: {
                return CLUSTER_LINK_RECORD;
            }
            case 10001: {
                return MIRROR_TOPIC_RECORD;
            }
            case 10002: {
                return MIRROR_TOPIC_CHANGE_RECORD;
            }
            case 10003: {
                return REMOVE_CLUSTER_LINK_RECORD;
            }
            case 10004: {
                return ENCRYPTED_ENVELOPE_RECORD;
            }
            case 10005: {
                return INSTALL_METADATA_ENCRYPTOR_RECORD;
            }
            case 10015: {
                return BROKER_REPLICA_EXCLUSION_RECORD;
            }
        }
        throw new UnsupportedVersionException("Unknown metadata id " + id);
    }

    public ApiMessage newMetadataRecord() {
        switch (this.id) {
            case 0: {
                return new RegisterBrokerRecord();
            }
            case 1: {
                return new UnregisterBrokerRecord();
            }
            case 2: {
                return new TopicRecord();
            }
            case 3: {
                return new PartitionRecord();
            }
            case 4: {
                return new ConfigRecord();
            }
            case 5: {
                return new PartitionChangeRecord();
            }
            case 6: {
                return new AccessControlRecord();
            }
            case 7: {
                return new FenceBrokerRecord();
            }
            case 8: {
                return new UnfenceBrokerRecord();
            }
            case 9: {
                return new RemoveTopicRecord();
            }
            case 10: {
                return new DelegationTokenRecord();
            }
            case 11: {
                return new UserScramCredentialRecord();
            }
            case 12: {
                return new FeatureLevelRecord();
            }
            case 14: {
                return new ClientQuotaRecord();
            }
            case 15: {
                return new ProducerIdsRecord();
            }
            case 17: {
                return new BrokerRegistrationChangeRecord();
            }
            case 18: {
                return new AccessControlEntryRecord();
            }
            case 19: {
                return new RemoveAccessControlEntryRecord();
            }
            case 20: {
                return new NoOpRecord();
            }
            case 10000: {
                return new ClusterLinkRecord();
            }
            case 10001: {
                return new MirrorTopicRecord();
            }
            case 10002: {
                return new MirrorTopicChangeRecord();
            }
            case 10003: {
                return new RemoveClusterLinkRecord();
            }
            case 10004: {
                return new EncryptedEnvelopeRecord();
            }
            case 10005: {
                return new InstallMetadataEncryptorRecord();
            }
            case 10015: {
                return new BrokerReplicaExclusionRecord();
            }
        }
        throw new UnsupportedVersionException("Unknown metadata id " + this.id);
    }

    public short id() {
        return this.id;
    }

    public short lowestSupportedVersion() {
        return this.lowestSupportedVersion;
    }

    public short highestSupportedVersion() {
        return this.highestSupportedVersion;
    }

    public String toString() {
        return this.name();
    }
}

