/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ConfigRecord
implements ApiMessage {
    byte resourceType;
    String resourceName;
    String name;
    String value;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("resource_type", (Type)Type.INT8, "The type of resource this configuration applies to."), new Field("resource_name", (Type)Type.COMPACT_STRING, "The name of the resource this configuration applies to."), new Field("name", (Type)Type.COMPACT_STRING, "The name of the configuration key."), new Field("value", (Type)Type.COMPACT_NULLABLE_STRING, "The value of the configuration, or null if the it should be deleted."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ConfigRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ConfigRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ConfigRecord() {
        this.resourceType = 0;
        this.resourceName = "";
        this.name = "";
        this.value = "";
    }

    public short apiKey() {
        return 4;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.resourceType = _readable.readByte();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field resourceName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field resourceName had invalid length " + length);
        }
        this.resourceName = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field name was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field name had invalid length " + length);
        }
        this.name = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.value = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeByte(this.resourceType);
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.resourceName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.name);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        if (this.value == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(1);
        byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'resourceName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.resourceName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'name' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.name, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this.value == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigRecord)) {
            return false;
        }
        ConfigRecord other = (ConfigRecord)obj;
        if (this.resourceType != other.resourceType) {
            return false;
        }
        if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.resourceType;
        hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
        return hashCode;
    }

    public ConfigRecord duplicate() {
        ConfigRecord _duplicate = new ConfigRecord();
        _duplicate.resourceType = this.resourceType;
        _duplicate.resourceName = this.resourceName;
        _duplicate.name = this.name;
        _duplicate.value = this.value == null ? null : this.value;
        return _duplicate;
    }

    public String toString() {
        return "ConfigRecord(resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
    }

    public byte resourceType() {
        return this.resourceType;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConfigRecord setResourceType(byte v) {
        this.resourceType = v;
        return this;
    }

    public ConfigRecord setResourceName(String v) {
        this.resourceName = v;
        return this;
    }

    public ConfigRecord setName(String v) {
        this.name = v;
        return this;
    }

    public ConfigRecord setValue(String v) {
        this.value = v;
        return this;
    }
}

