/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokerRegistrationTest {
    private static final List<BrokerRegistration> REGISTRATIONS = Arrays.asList(new BrokerRegistration(0, 0L, Uuid.fromString((String)"pc1GhUlBS92cGGaKXl6ipw"), Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9090)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)2)), Optional.empty(), false), new BrokerRegistration(1, 0L, Uuid.fromString((String)"3MfdxWlNSn2UDYsmDP1pYg"), Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9091)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)2)), Optional.empty(), false), new BrokerRegistration(2, 0L, Uuid.fromString((String)"eY7oaG1RREie5Kk9uy1l6g"), Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9092)), Collections.singletonMap("foo", VersionRange.of((short)2, (short)3)), Optional.of("myrack"), false));

    @Test
    public void testValues() {
        Assertions.assertEquals((int)0, (int)REGISTRATIONS.get(0).id());
        Assertions.assertEquals((int)1, (int)REGISTRATIONS.get(1).id());
        Assertions.assertEquals((int)2, (int)REGISTRATIONS.get(2).id());
    }

    @Test
    public void testEquals() {
        Assertions.assertFalse((boolean)REGISTRATIONS.get(0).equals((Object)REGISTRATIONS.get(1)));
        Assertions.assertFalse((boolean)REGISTRATIONS.get(1).equals((Object)REGISTRATIONS.get(0)));
        Assertions.assertFalse((boolean)REGISTRATIONS.get(0).equals((Object)REGISTRATIONS.get(2)));
        Assertions.assertFalse((boolean)REGISTRATIONS.get(2).equals((Object)REGISTRATIONS.get(0)));
        Assertions.assertTrue((boolean)REGISTRATIONS.get(0).equals((Object)REGISTRATIONS.get(0)));
        Assertions.assertTrue((boolean)REGISTRATIONS.get(1).equals((Object)REGISTRATIONS.get(1)));
        Assertions.assertTrue((boolean)REGISTRATIONS.get(2).equals((Object)REGISTRATIONS.get(2)));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"BrokerRegistration(id=1, epoch=0, incarnationId=3MfdxWlNSn2UDYsmDP1pYg, listeners=[Endpoint(listenerName='INTERNAL', securityProtocol=PLAINTEXT, host='localhost', port=9091)], supportedFeatures={foo: 1-2}, rack=Optional.empty, fenced=false)", (Object)REGISTRATIONS.get(1).toString());
    }

    @Test
    public void testFromRecordAndToRecord() {
        this.testRoundTrip(REGISTRATIONS.get(0));
        this.testRoundTrip(REGISTRATIONS.get(1));
        this.testRoundTrip(REGISTRATIONS.get(2));
    }

    private void testRoundTrip(BrokerRegistration registration) {
        ApiMessageAndVersion messageAndVersion = registration.toRecord();
        BrokerRegistration registration2 = BrokerRegistration.fromRecord((RegisterBrokerRecord)((RegisterBrokerRecord)messageAndVersion.message()));
        Assertions.assertEquals((Object)registration, (Object)registration2);
        ApiMessageAndVersion messageAndVersion2 = registration2.toRecord();
        Assertions.assertEquals((Object)messageAndVersion, (Object)messageAndVersion2);
    }

    @Test
    public void testToNode() {
        Assertions.assertEquals(Optional.empty(), (Object)REGISTRATIONS.get(0).node("NONEXISTENT"));
        Assertions.assertEquals(Optional.of(new Node(0, "localhost", 9090, null)), (Object)REGISTRATIONS.get(0).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(1, "localhost", 9091, null)), (Object)REGISTRATIONS.get(1).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(2, "localhost", 9092, "myrack")), (Object)REGISTRATIONS.get(2).node("INTERNAL"));
    }
}

