/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveFeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MockSnapshotConsumer;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class FeaturesImageTest {
    static final FeaturesImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final FeaturesDelta DELTA1;
    static final FeaturesImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(FeaturesImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(FeaturesImage image) throws Throwable {
        MockSnapshotConsumer writer = new MockSnapshotConsumer();
        image.write((Consumer)writer);
        FeaturesDelta delta = new FeaturesDelta(FeaturesImage.EMPTY);
        RecordTestUtils.replayAllBatches(delta, writer.batches());
        FeaturesImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    static {
        HashMap<String, Short> map1 = new HashMap<String, Short>();
        map1.put("foo", (short)2);
        map1.put("bar", (short)1);
        map1.put("baz", (short)8);
        IMAGE1 = new FeaturesImage(map1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)3), MetadataRecordType.FEATURE_LEVEL_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveFeatureLevelRecord().setName("bar"), MetadataRecordType.REMOVE_FEATURE_LEVEL_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveFeatureLevelRecord().setName("baz"), MetadataRecordType.REMOVE_FEATURE_LEVEL_RECORD.highestSupportedVersion()));
        DELTA1 = new FeaturesDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<String, Short> map2 = new HashMap<String, Short>();
        map2.put("foo", (short)3);
        IMAGE2 = new FeaturesImage(map2);
    }
}

