/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.MockSnapshotConsumer;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationsImageTest {
    static final ConfigurationsImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ConfigurationsDelta DELTA1;
    static final ConfigurationsImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(ConfigurationsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(ConfigurationsImage image) throws Throwable {
        MockSnapshotConsumer writer = new MockSnapshotConsumer();
        image.write((Consumer)writer, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE, KafkaConfigSchema.EMPTY);
        ConfigurationsDelta delta = new ConfigurationsDelta(ConfigurationsImage.EMPTY);
        RecordTestUtils.replayAllBatches(delta, writer.batches());
        ConfigurationsImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    static {
        HashMap<ConfigResource, ConfigurationImage> map1 = new HashMap<ConfigResource, ConfigurationImage>();
        HashMap<String, String> broker0Map = new HashMap<String, String>();
        broker0Map.put("foo", "bar");
        broker0Map.put("baz", "quux");
        map1.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigurationImage(broker0Map));
        HashMap<String, String> broker1Map = new HashMap<String, String>();
        broker1Map.put("foobar", "foobaz");
        map1.put(new ConfigResource(ConfigResource.Type.BROKER, "1"), new ConfigurationImage(broker1Map));
        IMAGE1 = new ConfigurationsImage(map1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("1").setName("barfoo").setValue("bazfoo"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1 = new ConfigurationsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<ConfigResource, ConfigurationImage> map2 = new HashMap<ConfigResource, ConfigurationImage>();
        HashMap<String, String> broker0Map2 = new HashMap<String, String>();
        broker0Map2.put("baz", "quux");
        map2.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigurationImage(broker0Map2));
        HashMap<String, String> broker1Map2 = new HashMap<String, String>();
        broker1Map2.put("foobar", "foobaz");
        broker1Map2.put("barfoo", "bazfoo");
        map2.put(new ConfigResource(ConfigResource.Type.BROKER, "1"), new ConfigurationImage(broker1Map2));
        IMAGE2 = new ConfigurationsImage(map2);
    }
}

