/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.types.TaggedFields;
import org.apache.kafka.controller.PartitionChangeBuilder;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.controller.PartitionReassignmentRevert;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class PartitionChangeBuilderTest {
    private static final PartitionRegistration FOO = new PartitionRegistration(new int[]{2, 1, 3}, new int[]{2, 1, 3}, Replicas.NONE, Replicas.NONE, 1, LeaderRecoveryState.RECOVERED, 100, 200);
    private static final PartitionRegistration FOO_CL = new PartitionRegistration(new int[]{2, 1, 3}, new int[]{2, 1, 3}, Replicas.NONE, Replicas.NONE, 1, LeaderRecoveryState.RECOVERED, 100, 200, 1, PartitionRegistration.LinkState.ACTIVE);
    private static final Uuid FOO_ID = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
    private static final PartitionRegistration BAR = new PartitionRegistration(new int[]{1, 2, 3, 4}, new int[]{1, 2, 3}, new int[]{1}, new int[]{4}, 1, LeaderRecoveryState.RECOVERED, 100, 200);
    private static final Uuid BAR_ID = Uuid.fromString((String)"LKfUsCBnQKekvL9O5dY9nw");
    private static final PartitionRegistration BAZ = new PartitionRegistration(new int[]{2, 1, 3}, new int[]{1, 3}, Replicas.NONE, Replicas.NONE, 3, LeaderRecoveryState.RECOVERED, 100, 200);
    private static final Uuid BAZ_ID = Uuid.fromString((String)"wQzt5gkSTwuQNXZF5gIw7A");
    private static final PartitionRegistration OFFLINE = new PartitionRegistration(new int[]{2, 1, 3}, new int[]{3}, Replicas.NONE, Replicas.NONE, -1, LeaderRecoveryState.RECOVERED, 100, 200);
    private static final Uuid OFFLINE_ID = Uuid.fromString((String)"LKfUsCBnQKekvL9O5dY9nw");

    @Test
    public void testChangeRecordIsNoOp() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)0, (int)0);
        TaggedFields taggedFields = (TaggedFields)PartitionChangeRecord.SCHEMA_0.get((int)2).def.type;
        Assertions.assertEquals((int)8, (int)taggedFields.numFields());
        Assertions.assertTrue((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord()));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLeader(1)));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setIsr(Arrays.asList(1, 2, 3))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setRemovingReplicas(Arrays.asList(1))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setAddingReplicas(Arrays.asList(4))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())));
    }

    private static PartitionChangeBuilder createFooBuilder() {
        return new PartitionChangeBuilder(FOO, FOO_ID, 0, r -> r != 3, true);
    }

    private static PartitionChangeBuilder createLinkedFooBuilder() {
        return new PartitionChangeBuilder(FOO_CL, FOO_ID, 0, r -> r != 3, true);
    }

    private static PartitionChangeBuilder createBarBuilder() {
        return new PartitionChangeBuilder(BAR, BAR_ID, 0, r -> r != 3, true);
    }

    private static PartitionChangeBuilder createBazBuilder() {
        return new PartitionChangeBuilder(BAZ, BAZ_ID, 0, __ -> true, true);
    }

    private static PartitionChangeBuilder createOfflineBuilder() {
        return new PartitionChangeBuilder(OFFLINE, OFFLINE_ID, 0, r -> r == 1, true);
    }

    private static void assertElectLeaderEquals(PartitionChangeBuilder builder, int expectedNode, boolean expectedUnclean) {
        PartitionChangeBuilder.ElectionResult electionResult = builder.electLeader();
        Assertions.assertEquals((int)expectedNode, (int)electionResult.node);
        Assertions.assertEquals((Object)expectedUnclean, (Object)electionResult.unclean);
    }

    @Test
    public void testElectLeader() {
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.PREFERRED), 2, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setTargetIsr(Arrays.asList(1, 3)), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsr(Arrays.asList(1, 3)), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setTargetIsr(Arrays.asList(3)), -1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsr(Arrays.asList(3)), 2, true);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsr(Arrays.asList(4)).setTargetReplicas(Arrays.asList(2, 1, 3, 4)), 4, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder().setElection(PartitionChangeBuilder.Election.PREFERRED), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder(), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN), 3, false);
    }

    private static void testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilder builder, PartitionChangeRecord record, int expectedLeader) {
        builder.triggerLeaderEpochBumpIfNeeded(record);
        Assertions.assertEquals((int)expectedLeader, (int)record.leader());
    }

    @Test
    public void testTriggerLeaderEpochBumpIfNeeded() {
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder(), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetIsr(Arrays.asList(2, 1)), new PartitionChangeRecord(), 1);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetIsr(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord().setLeader(2), 2);
    }

    @Test
    public void testNoChange() {
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder().build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder().build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBazBuilder().setElection(PartitionChangeBuilder.Election.PREFERRED).build());
    }

    @Test
    public void testIsrChangeAndLeaderBump() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2, 1)).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetIsr(Arrays.asList(2, 1)).build());
    }

    @Test
    public void testIsrChangeAndLeaderChange() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2, 3)).setLeader(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetIsr(Arrays.asList(2, 3)).build());
    }

    @Test
    public void testReassignmentRearrangesReplicas() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).build());
    }

    @Test
    public void testIsrEnlargementCompletesReassignment() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(Arrays.asList(2, 3, 4)).setIsr(Arrays.asList(2, 3, 4)).setLeader(2).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createBarBuilder().setTargetIsr(Arrays.asList(1, 2, 3, 4)).build());
    }

    @Test
    public void testRevertReassignment() {
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(BAR);
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)revert.isr());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2, 3)).setLeader(1).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createBarBuilder().setTargetReplicas(revert.replicas()).setTargetIsr(revert.isr()).setTargetRemoving(Collections.emptyList()).setTargetAdding(Collections.emptyList()).build());
    }

    @Test
    public void testRemovingReplicaReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas), Arrays.asList(1, 2));
        Assertions.assertEquals(Collections.singletonList(3), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)replicas.merged());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2)).setIsr(Arrays.asList(2, 1)).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(replicas.merged()).setTargetRemoving(replicas.removing()).build());
    }

    @Test
    public void testAddingReplicaReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas), Arrays.asList(1, 2, 3, 4));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.singletonList(4), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)replicas.merged());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2, 3, 4)).setAddingReplicas(Collections.singletonList(4)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(replicas.merged()).setTargetAdding(replicas.adding()).build());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testChangeInLeadershipDoesNotChangeRecoveryState(boolean isLeaderRecoverySupported) {
        int noChange = -1;
        int leaderId = 1;
        LeaderRecoveryState recoveryState = LeaderRecoveryState.RECOVERING;
        PartitionRegistration registration = new PartitionRegistration(new int[]{leaderId, leaderId + 1, leaderId + 2}, new int[]{leaderId}, Replicas.NONE, Replicas.NONE, leaderId, recoveryState, 100, 200);
        PartitionChangeBuilder offlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> false, isLeaderRecoverySupported);
        offlineBuilder.setTargetIsr(Collections.emptyList());
        PartitionChangeRecord changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)offlineBuilder.build().get()).message();
        Assertions.assertEquals((byte)-1, (byte)changeRecord.leaderRecoveryState());
        Assertions.assertEquals((int)-1, (int)changeRecord.leader());
        registration = registration.merge(changeRecord);
        Assertions.assertEquals((int)-1, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)recoveryState, (Object)registration.leaderRecoveryState);
        PartitionChangeBuilder onlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> true, isLeaderRecoverySupported);
        changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)onlineBuilder.build().get()).message();
        Assertions.assertEquals((byte)-1, (byte)changeRecord.leaderRecoveryState());
        registration = registration.merge(changeRecord);
        Assertions.assertEquals((int)leaderId, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)recoveryState, (Object)registration.leaderRecoveryState);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testUncleanSetsLeaderRecoveringState(boolean isLeaderRecoverySupported) {
        int noChange = -1;
        int leaderId = 1;
        PartitionRegistration registration = new PartitionRegistration(new int[]{leaderId, leaderId + 1, leaderId + 2}, new int[]{leaderId + 1, leaderId + 2}, Replicas.NONE, Replicas.NONE, -1, LeaderRecoveryState.RECOVERED, 100, 200);
        PartitionChangeBuilder onlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> brokerId == leaderId, isLeaderRecoverySupported).setElection(PartitionChangeBuilder.Election.UNCLEAN);
        PartitionChangeRecord changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)onlineBuilder.build().get()).message();
        byte expectedRecoveryChange = -1;
        if (isLeaderRecoverySupported) {
            expectedRecoveryChange = LeaderRecoveryState.RECOVERING.value();
        }
        Assertions.assertEquals((byte)expectedRecoveryChange, (byte)changeRecord.leaderRecoveryState());
        Assertions.assertEquals((int)leaderId, (int)changeRecord.leader());
        Assertions.assertEquals((int)1, (int)changeRecord.isr().size());
        Assertions.assertEquals((int)leaderId, (Integer)changeRecord.isr().get(0));
        registration = registration.merge(changeRecord);
        LeaderRecoveryState expectedRecovery = LeaderRecoveryState.RECOVERED;
        if (isLeaderRecoverySupported) {
            expectedRecovery = LeaderRecoveryState.RECOVERING;
        }
        Assertions.assertEquals((int)leaderId, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)expectedRecovery, (Object)registration.leaderRecoveryState);
    }

    @Test
    public void testUncleanLeaderElection() {
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2)).setLeader(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion());
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsr(Arrays.asList(3)).build());
        expectedRecord = new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(OFFLINE_ID).setPartitionId(0).setIsr(Arrays.asList(1)).setLeader(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion());
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createOfflineBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createOfflineBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsr(Arrays.asList(2)).build());
    }

    @Test
    public void testClusterLinkFieldsForMirrorPartition() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode).setLinkedLeaderEpoch(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode).setLinkedLeaderEpoch(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkFailed(true).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode).setLinkedLeaderEpoch(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(1).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode).setLinkedLeaderEpoch(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(2).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(2).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode).setLinkedLeaderEpoch(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(2).setLinkFailed(true).build());
    }

    @Test
    public void testClusterLinkFieldsForNonMirrorPartition() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(32).setLinkFailed(true).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(64).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).build());
    }
}

