/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class FeatureControlManagerTest {
    private static Map<String, VersionRange> rangeMap(Object ... args) {
        HashMap<String, VersionRange> result = new HashMap<String, VersionRange>();
        for (int i = 0; i < args.length; i += 3) {
            String feature = (String)args[i];
            Integer low = (Integer)args[i + 1];
            Integer high = (Integer)args[i + 2];
            result.put(feature, VersionRange.of((short)low.shortValue(), (short)high.shortValue()));
        }
        return result;
    }

    private static Map<String, Short> versionMap(Object ... args) {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (int i = 0; i < args.length; i += 2) {
            String feature = (String)args[i];
            Integer ver = (Integer)args[i + 1];
            result.put(feature, ver.shortValue());
        }
        return result;
    }

    public static QuorumFeatures features(Object ... args) {
        return QuorumFeatures.create((int)0, FeatureControlManagerTest.rangeMap(args));
    }

    private static Map<String, Short> updateMap(Object ... args) {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (int i = 0; i < args.length; i += 2) {
            String feature = (String)args[i];
            Integer ver = (Integer)args[i + 1];
            result.put(feature, ver.shortValue());
        }
        return result;
    }

    @Test
    public void testUpdateFeatures() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        snapshotRegistry.getOrCreateSnapshot(-1L);
        FeatureControlManager manager = new FeatureControlManager(logContext, FeatureControlManagerTest.features("foo", 1, 2), snapshotRegistry);
        Assertions.assertEquals((Object)new FinalizedControllerFeatures(Collections.emptyMap(), -1L), (Object)manager.finalizedFeatures(-1L));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "The controller does not support the given feature range."))), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 3), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.emptyMap(), false));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 2, "bar", 1), Collections.emptyMap(), Collections.emptyMap(), false);
        HashMap<String, ApiError> expectedMap = new HashMap<String, ApiError>();
        expectedMap.put("foo", ApiError.NONE);
        expectedMap.put("bar", new ApiError(Errors.INVALID_UPDATE_VERSION, "The controller does not support the given feature."));
        Assertions.assertEquals(expectedMap, (Object)result.response());
        ArrayList<ApiMessageAndVersion> expectedMessages = new ArrayList<ApiMessageAndVersion>();
        expectedMessages.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2), 0));
        Assertions.assertEquals(expectedMessages, (Object)result.records());
    }

    @Test
    public void testReplay() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureLevelRecord record = new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2);
        snapshotRegistry.getOrCreateSnapshot(-1L);
        FeatureControlManager manager = new FeatureControlManager(logContext, FeatureControlManagerTest.features("foo", 1, 2), snapshotRegistry);
        manager.replay(record);
        snapshotRegistry.getOrCreateSnapshot(123L);
        Assertions.assertEquals((Object)new FinalizedControllerFeatures(FeatureControlManagerTest.versionMap("foo", 2), 123L), (Object)manager.finalizedFeatures(123L));
    }

    @Test
    public void testUpdateFeaturesErrorCases() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureControlManager manager = new FeatureControlManager(logContext, FeatureControlManagerTest.features("foo", 1, 5, "bar", 1, 2), snapshotRegistry);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "Broker 5 does not support the given feature range."))), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 3), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.singletonMap(5, FeatureControlManagerTest.rangeMap(new Object[0])), false));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 3), Collections.emptyMap(), Collections.emptyMap(), false);
        Assertions.assertEquals(Collections.singletonMap("foo", ApiError.NONE), (Object)result.response());
        manager.replay((FeatureLevelRecord)((ApiMessageAndVersion)result.records().get(0)).message());
        snapshotRegistry.getOrCreateSnapshot(3L);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "Can't downgrade the maximum version of this feature without setting the upgrade type to safe or unsafe downgrade."))), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 2), Collections.emptyMap(), Collections.emptyMap(), false));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2), 0)), Collections.singletonMap("foo", ApiError.NONE)), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 2), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.emptyMap(), false));
    }

    @Test
    public void testFeatureControlIterator() throws Exception {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureControlManager manager = new FeatureControlManager(logContext, FeatureControlManagerTest.features("foo", 1, 5, "bar", 1, 2), snapshotRegistry);
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 5, "bar", 1), Collections.emptyMap(), Collections.emptyMap(), false);
        RecordTestUtils.replayAll(manager, result.records());
        RecordTestUtils.assertBatchIteratorContains(Arrays.asList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)5), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("bar").setFeatureLevel((short)1), 0))), (Iterator<List<ApiMessageAndVersion>>)manager.iterator(Long.MAX_VALUE));
    }
}

