/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentClusterIdException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.MockControllerMetrics;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.MockRandom;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ClusterControlManagerTest {
    @Test
    public void testReplay() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.unfenced(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord);
        clusterControl.checkBrokerEpoch(1, 100L);
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(1, 101L));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(2, 100L));
        Assertions.assertFalse((boolean)clusterControl.unfenced(0));
        Assertions.assertFalse((boolean)clusterControl.unfenced(1));
        UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(1).setEpoch(100L);
        clusterControl.replay(unfenceBrokerRecord);
        Assertions.assertFalse((boolean)clusterControl.unfenced(0));
        Assertions.assertTrue((boolean)clusterControl.unfenced(1));
    }

    @Test
    public void testRegistrationWithIncorrectClusterId() throws Exception {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        Assertions.assertThrows(InconsistentClusterIdException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("WIjw3grwRZmR2uOpdpVXbg").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Collections.emptyMap(), 456L)));
    }

    @Test
    public void testUnfencedBrokerEndpoints() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        ListenerName externalListenerName = new ListenerName("EXTERNAL");
        ListenerName internalListenerName = new ListenerName("INTERNAL");
        ListenerName nonExistingListenerName = new ListenerName("NONEXISTING");
        RegisterBrokerRecord broker1Record = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("rack1");
        broker1Record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT.id).setPort(9092).setName(externalListenerName.value()).setHost("localhost"));
        broker1Record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName(internalListenerName.value()).setHost("localhost"));
        clusterControl.replay(broker1Record);
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Collections.emptySet());
        clusterControl.replay(new UnfenceBrokerRecord().setId(1).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9092).setRack("rack1")}));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9093).setRack("rack1")}));
        RegisterBrokerRecord broker2Record = new RegisterBrokerRecord().setBrokerId(2).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setRack("rack2");
        broker2Record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT.id).setPort(9094).setName(externalListenerName.value()).setHost("localhost"));
        clusterControl.replay(broker2Record);
        clusterControl.replay(new UnfenceBrokerRecord().setId(2).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9092).setRack("rack1"), new MetadataResponseData.MetadataResponseBroker().setNodeId(2).setHost("localhost").setPort(9094).setRack("rack2")}));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9093).setRack("rack1")}));
        clusterControl.replay(new FenceBrokerRecord().setId(1).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(2).setHost("localhost").setPort(9094).setRack("rack2")}));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        clusterControl.replay(new FenceBrokerRecord().setId(2).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Collections.emptySet());
    }

    private void assertUnfencedEndpoints(ClusterControlManager clusterControl, ListenerName listenerName, Set<MetadataResponseData.MetadataResponseBroker> expectedUnfenced) {
        MetadataResponseData.MetadataResponseBrokerCollection actualUnfenced = clusterControl.unfencedBrokerEndpoints(listenerName);
        Assertions.assertEquals((int)expectedUnfenced.size(), (int)actualUnfenced.size());
        for (MetadataResponseData.MetadataResponseBroker expectedBroker : expectedUnfenced) {
            Assertions.assertEquals((Object)expectedBroker, (Object)actualUnfenced.find((ImplicitLinkedHashCollection.Element)expectedBroker));
        }
    }

    @Test
    public void testUnregister() throws Exception {
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("arack");
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        clusterControl.replay(brokerRecord);
        Assertions.assertEquals((Object)new BrokerRegistration(1, 100L, Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w"), Collections.singletonMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "example.com", 9092)), Collections.emptyMap(), Optional.of("arack"), true), clusterControl.brokerRegistrations().get(1));
        UnregisterBrokerRecord unregisterRecord = new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L);
        clusterControl.replay(unregisterRecord);
        Assertions.assertFalse((boolean)clusterControl.brokerRegistrations().containsKey(1));
    }

    @ParameterizedTest
    @ValueSource(ints={3, 10})
    public void testPlaceReplicas(int numUsableBrokers) throws Exception {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        MockRandom random = new MockRandom();
        final ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setReplicaPlacer((ReplicaPlacer)new StripedReplicaPlacer((Random)random)).build();
        clusterControl.activate();
        int replicationFactor = 3;
        for (i = 0; i < numUsableBrokers; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i);
            brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord);
            UnfenceBrokerRecord unfenceRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceRecord);
            clusterControl.heartbeatManager().touch(i, false, 0L);
        }
        for (i = 0; i < numUsableBrokers; ++i) {
            Assertions.assertTrue((boolean)clusterControl.unfenced(i), (String)String.format("broker %d was not unfenced.", i));
        }
        int excludedBrokerId = -1;
        if (numUsableBrokers > replicationFactor) {
            excludedBrokerId = random.nextInt(numUsableBrokers);
            BrokerReplicaExclusionRecord exclusionRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Collections.singletonList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(excludedBrokerId).setReason("test")));
            clusterControl.replay(exclusionRecord);
            Assertions.assertTrue((boolean)clusterControl.activeBrokerReplicaExclusions().containsKey(excludedBrokerId), (String)"Expected the excluded broker %d to be in the active broker replica exclusions");
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            List results = clusterControl.replicaPlacer().place(new PlacementSpec(0, 1, 3), new ClusterDescriber(){

                public Iterator<UsableBroker> usableBrokers() {
                    return clusterControl.usableBrokers();
                }
            });
            HashSet<Integer> seen = new HashSet<Integer>();
            for (Integer result : (List)results.get(0)) {
                Assertions.assertTrue((result >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((result < numUsableBrokers ? 1 : 0) != 0);
                Assertions.assertNotEquals((Integer)result, (int)excludedBrokerId, (String)String.format("Expected the replica to not be assigned to the excluded broker %d", excludedBrokerId));
                Assertions.assertTrue((boolean)seen.add(result));
            }
        }
    }

    @Test
    public void testIterator() throws Exception {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.unfenced(0));
        for (i = 0; i < 3; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i).setRack(null);
            brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092 + i).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord);
        }
        for (i = 0; i < 2; ++i) {
            UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceBrokerRecord);
        }
        BrokerReplicaExclusionRecord exclusionRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("2"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(3).setReason("3")));
        clusterControl.replay(exclusionRecord);
        List<List<ApiMessageAndVersion>> expectedBatches = Arrays.asList(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(false), 0)), Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(2).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9094).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(true), 0), new ApiMessageAndVersion((ApiMessage)exclusionRecord, 0)));
        RecordTestUtils.assertBatchIteratorContains(expectedBatches, (Iterator<List<ApiMessageAndVersion>>)clusterControl.iterator(Long.MAX_VALUE));
    }

    @Test
    public void testEmptyIterator() throws Exception {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        List<List<ApiMessageAndVersion>> expectedBatches = Collections.singletonList(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new BrokerReplicaExclusionRecord().setBrokerExclusions(Collections.emptyList()), 0)));
        RecordTestUtils.assertBatchIteratorContains(expectedBatches, (Iterator<List<ApiMessageAndVersion>>)clusterControl.iterator(Long.MAX_VALUE));
    }

    @Test
    public void testReplayExclusionRecordWorks() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        BrokerReplicaExclusionRecord record = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("2"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(3).setReason("3")));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        expectedExclusionState.put(1, "1");
        expectedExclusionState.put(2, "2");
        expectedExclusionState.put(3, "3");
        clusterControl.replay(record);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
        BrokerReplicaExclusionRecord newRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("10")));
        clusterControl.replay(newRecord);
        expectedExclusionState.put(2, "10");
        expectedExclusionState.remove(3);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
    }

    @Test
    public void testProcessAlterReplicaExclusions() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET)));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        expectedExclusionState.put(1, "1");
        expectedExclusionState.put(2, "2");
        ControllerResult result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, requestedExclusions, true, false, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
        BrokerReplicaExclusionRecord record = new BrokerReplicaExclusionRecord().setBrokerExclusions(((AlterReplicaExclusionsReply)result.response()).exclusionResults().stream().map(r -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(r.brokerId()).setReason(r.reason())).collect(Collectors.toList()));
        clusterControl.replay(record);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
        result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, expectedExclusionState, requestedExclusions, true, true, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
    }

    @Test
    public void testProcessAlterReplicaExclusionsDoesNotApplyWhenAnErrorIsPresent() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).build();
        clusterControl.activate();
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.DELETE)));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        ControllerResult result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, requestedExclusions, false, false, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
    }

    private void verifyExclusionResponse(Map<Integer, String> expectedExclusions, Set<AlterReplicaExclusionOp> requestedExclusions, boolean expectedToBeSuccessful, boolean expectedToBeSuccessfulNoOp, ControllerResult<AlterReplicaExclusionsReply> receivedResult, ClusterControlManager controlManager) {
        this.verifyExclusionResponse(expectedExclusions, Collections.emptyMap(), requestedExclusions, expectedToBeSuccessful, expectedToBeSuccessfulNoOp, receivedResult, controlManager);
    }

    private void verifyExclusionResponse(Map<Integer, String> expectedExclusions, Map<Integer, String> expectedInMemoryExclusions, Set<AlterReplicaExclusionOp> requestedExclusions, boolean expectedToBeSuccessful, boolean expectedToBeSuccessfulNoOp, ControllerResult<AlterReplicaExclusionsReply> receivedResult, ClusterControlManager controlManager) {
        if (expectedToBeSuccessfulNoOp) {
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessfulNoOp(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"Expected no records to be persisted because the request was a no-op");
            Assertions.assertEquals((int)requestedExclusions.size(), (int)((AlterReplicaExclusionsReply)receivedResult.response()).exclusionResults().size());
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        } else if (expectedToBeSuccessful) {
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertFalse((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessfulNoOp(), (String)"Expected the exclusion request to NOT have been a no-op");
            Assertions.assertEquals((int)1, (int)receivedResult.records().size());
            BrokerReplicaExclusionRecord expectedRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(expectedExclusions.entrySet().stream().map(entry -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setReason((String)entry.getValue()).setBrokerId((Integer)entry.getKey())).collect(Collectors.toList()));
            Assertions.assertEquals((Object)expectedRecord, (Object)((ApiMessageAndVersion)receivedResult.records().get(0)).message());
            Assertions.assertEquals((int)requestedExclusions.size(), (int)((AlterReplicaExclusionsReply)receivedResult.response()).exclusionResults().size());
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        } else {
            Assertions.assertFalse((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have NOT applied");
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"No records should have been persistent when exclusions were not applied succesfully");
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        }
    }
}

