/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.metalog.LocalLogManagerTestEnv;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumControllerTestEnv
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(QuorumControllerTestEnv.class);
    private final List<QuorumController> controllers;
    private final LocalLogManagerTestEnv logEnv;

    public QuorumControllerTestEnv(LocalLogManagerTestEnv logEnv, Consumer<QuorumController.Builder> builderConsumer) throws Exception {
        this(logEnv, builderConsumer, OptionalLong.empty(), OptionalLong.empty());
    }

    public QuorumControllerTestEnv(LocalLogManagerTestEnv logEnv, Consumer<QuorumController.Builder> builderConsumer, OptionalLong sessionTimeoutMillis, OptionalLong leaderImbalanceCheckIntervalNs) throws Exception {
        this.logEnv = logEnv;
        int numControllers = logEnv.logManagers().size();
        this.controllers = new ArrayList<QuorumController>(numControllers);
        try {
            for (int i = 0; i < numControllers; ++i) {
                QuorumController.Builder builder = new QuorumController.Builder(i, logEnv.clusterId());
                builder.setRaftClient((RaftClient)logEnv.logManagers().get(i));
                sessionTimeoutMillis.ifPresent(timeout -> builder.setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)));
                builder.setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs);
                builderConsumer.accept(builder);
                this.controllers.add(builder.build());
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    QuorumController activeController() throws InterruptedException {
        AtomicReference<Object> value = new AtomicReference<Object>(null);
        TestUtils.retryOnExceptionWithTimeout((long)20000L, (long)3L, () -> {
            LeaderAndEpoch leader = this.logEnv.leaderAndEpoch();
            for (QuorumController controller : this.controllers) {
                if (!OptionalInt.of(controller.nodeId()).equals(leader.leaderId()) || controller.curClaimEpoch() != leader.epoch()) continue;
                value.set(controller);
                break;
            }
            if (value.get() == null) {
                throw new RuntimeException(String.format("Expected to see %s as leader", leader));
            }
        });
        return value.get();
    }

    public List<QuorumController> controllers() {
        return this.controllers;
    }

    @Override
    public void close() throws InterruptedException {
        for (QuorumController controller : this.controllers) {
            controller.beginShutdown();
        }
        for (QuorumController controller : this.controllers) {
            controller.close();
        }
    }
}

