/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumControllerMetricsTest {
    private static final String EXPECTED_GROUP = "kafka.controller";

    @Test
    public void testKafkaControllerMetricNames() {
        String expectedType = "KafkaController";
        Set expectedMetricNames = Utils.mkSet((Object[])new String[]{"ActiveControllerCount", "GlobalTopicCount", "GlobalPartitionCount", "OfflinePartitionsCount", "PreferredReplicaImbalanceCount"});
        QuorumControllerMetricsTest.assertMetricsCreatedAndRemovedUponClose(expectedType, expectedMetricNames);
    }

    @Test
    public void testControllerEventManagerMetricNames() {
        String expectedType = "ControllerEventManager";
        Set expectedMetricNames = Utils.mkSet((Object[])new String[]{"EventQueueTimeMs", "EventQueueProcessingTimeMs"});
        QuorumControllerMetricsTest.assertMetricsCreatedAndRemovedUponClose(expectedType, expectedMetricNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueTime() {
        MetricsRegistry registry = new MetricsRegistry();
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry);){
            quorumControllerMetrics.updateEventQueueTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueProcessingTime() {
        MetricsRegistry registry = new MetricsRegistry();
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry);){
            quorumControllerMetrics.updateEventQueueProcessingTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueProcessingTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertMetricsCreatedAndRemovedUponClose(String expectedType, Set<String> expectedMetricNames) {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry);){
                QuorumControllerMetricsTest.assertMetricsCreated(registry, expectedMetricNames, expectedType);
            }
            QuorumControllerMetricsTest.assertMetricsRemoved(registry, expectedMetricNames, expectedType);
        }
        finally {
            registry.shutdown();
        }
    }

    private static void assertMetricHistogram(MetricsRegistry registry, MetricName metricName, long count, double sum) {
        Histogram histogram = (Histogram)registry.allMetrics().get(metricName);
        Assertions.assertEquals((long)count, (long)histogram.count());
        Assertions.assertEquals((double)sum, (double)histogram.sum(), (double)0.1);
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName(EXPECTED_GROUP, type, name, null, mBeanName);
    }

    private static void assertMetricsCreated(MetricsRegistry registry, Set<String> expectedMetricNames, String expectedType) {
        expectedMetricNames.forEach(expectedName -> {
            MetricName expectMetricName = QuorumControllerMetricsTest.metricName(expectedType, expectedName);
            Assertions.assertTrue((boolean)registry.allMetrics().containsKey(expectMetricName), (String)("Missing metric: " + expectMetricName));
        });
    }

    private static void assertMetricsRemoved(MetricsRegistry registry, Set<String> expectedMetricNames, String expectedType) {
        expectedMetricNames.forEach(expectedName -> {
            MetricName expectMetricName = QuorumControllerMetricsTest.metricName(expectedType, expectedName);
            Assertions.assertFalse((boolean)registry.allMetrics().containsKey(expectMetricName), (String)("Found metric: " + expectMetricName));
        });
    }
}

