/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;

public class PartitionRegistration {
    public final int[] replicas;
    public final int[] isr;
    public final int[] removingReplicas;
    public final int[] addingReplicas;
    public final int leader;
    public final int leaderEpoch;
    public final int partitionEpoch;
    public final int linkedLeaderEpoch;
    public final LinkState linkState;

    public static boolean electionWasClean(int newLeader, int[] isr) {
        return newLeader == -1 || Replicas.contains(isr, newLeader);
    }

    public PartitionRegistration(PartitionRecord record) {
        this(Replicas.toArray(record.replicas()), Replicas.toArray(record.isr()), Replicas.toArray(record.removingReplicas()), Replicas.toArray(record.addingReplicas()), record.leader(), record.leaderEpoch(), record.partitionEpoch(), record.linkedLeaderEpoch(), record.linkState());
    }

    PartitionRegistration(int[] replicas, int[] isr, int[] removingReplicas, int[] addingReplicas, int leader, int leaderEpoch, int partitionEpoch, int linkedLeaderEpoch, int linkState) {
        this.replicas = replicas;
        this.isr = isr;
        this.removingReplicas = removingReplicas;
        this.addingReplicas = addingReplicas;
        this.leader = leader;
        this.leaderEpoch = leaderEpoch;
        this.partitionEpoch = partitionEpoch;
        this.linkedLeaderEpoch = linkedLeaderEpoch;
        this.linkState = LinkState.fromCode(linkState);
    }

    public PartitionRegistration(int[] replicas, int[] isr, int[] removingReplicas, int[] addingReplicas, int leader, int leaderEpoch, int partitionEpoch) {
        this(replicas, isr, removingReplicas, addingReplicas, leader, leaderEpoch, partitionEpoch, -1, -1);
    }

    public PartitionRegistration merge(PartitionChangeRecord record) {
        int newLeaderEpoch;
        int newLeader;
        int[] newAddingReplicas;
        int[] newReplicas = record.replicas() == null ? this.replicas : Replicas.toArray(record.replicas());
        int[] newIsr = record.isr() == null ? this.isr : Replicas.toArray(record.isr());
        int[] newRemovingReplicas = record.removingReplicas() == null ? this.removingReplicas : Replicas.toArray(record.removingReplicas());
        int[] nArray = newAddingReplicas = record.addingReplicas() == null ? this.addingReplicas : Replicas.toArray(record.addingReplicas());
        if (record.leader() == -2) {
            newLeader = this.leader;
            newLeaderEpoch = this.leaderEpoch;
        } else {
            newLeader = record.leader();
            newLeaderEpoch = this.leaderEpoch + 1;
        }
        int newLinkedLeaderEpoch = record.linkedLeaderEpoch() == -1 ? this.linkedLeaderEpoch : record.linkedLeaderEpoch();
        LinkState newLinkState = record.linkState() == LinkState.NOT_SET.levelCode ? this.linkState : LinkState.fromCode(record.linkState());
        return new PartitionRegistration(newReplicas, newIsr, newRemovingReplicas, newAddingReplicas, newLeader, newLeaderEpoch, this.partitionEpoch + 1, newLinkedLeaderEpoch, newLinkState.levelCode);
    }

    public String diff(PartitionRegistration prev) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        if (!Arrays.equals(this.replicas, prev.replicas)) {
            builder.append(prefix).append("replicas: ").append(Arrays.toString(prev.replicas)).append(" -> ").append(Arrays.toString(this.replicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.isr, prev.isr)) {
            builder.append(prefix).append("isr: ").append(Arrays.toString(prev.isr)).append(" -> ").append(Arrays.toString(this.isr));
            prefix = ", ";
        }
        if (!Arrays.equals(this.removingReplicas, prev.removingReplicas)) {
            builder.append(prefix).append("removingReplicas: ").append(Arrays.toString(prev.removingReplicas)).append(" -> ").append(Arrays.toString(this.removingReplicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.addingReplicas, prev.addingReplicas)) {
            builder.append(prefix).append("addingReplicas: ").append(Arrays.toString(prev.addingReplicas)).append(" -> ").append(Arrays.toString(this.addingReplicas));
            prefix = ", ";
        }
        if (this.leader != prev.leader) {
            builder.append(prefix).append("leader: ").append(prev.leader).append(" -> ").append(this.leader);
            prefix = ", ";
        }
        if (this.leaderEpoch != prev.leaderEpoch) {
            builder.append(prefix).append("leaderEpoch: ").append(prev.leaderEpoch).append(" -> ").append(this.leaderEpoch);
            prefix = ", ";
        }
        if (this.partitionEpoch != prev.partitionEpoch) {
            builder.append(prefix).append("partitionEpoch: ").append(prev.partitionEpoch).append(" -> ").append(this.partitionEpoch);
        }
        return builder.toString();
    }

    public void maybeLogPartitionChange(Logger log, String description, PartitionRegistration prev) {
        if (!PartitionRegistration.electionWasClean(this.leader, prev.isr)) {
            log.info("UNCLEAN partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        } else if (log.isDebugEnabled()) {
            log.debug("partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        }
    }

    public boolean hasLeader() {
        return this.leader != -1;
    }

    public boolean hasPreferredLeader() {
        return this.leader == this.preferredReplica();
    }

    public int preferredReplica() {
        return this.replicas.length == 0 ? -1 : this.replicas[0];
    }

    public ApiMessageAndVersion toRecord(Uuid topicId, int partitionId) {
        return new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(Replicas.toList(this.replicas)).setIsr(Replicas.toList(this.isr)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setLeader(this.leader).setLeaderEpoch(this.leaderEpoch).setPartitionEpoch(this.partitionEpoch).setLinkedLeaderEpoch(this.linkedLeaderEpoch).setLinkState(this.linkState.levelCode), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion());
    }

    public LeaderAndIsrRequestData.LeaderAndIsrPartitionState toLeaderAndIsrPartitionState(TopicIdPartition tip, boolean isNew) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tip.topicPartition().topic()).setTopicId(tip.topicId()).setPartitionIndex(tip.topicPartition().partition()).setControllerEpoch(-1).setLeader(this.leader).setLeaderEpoch(this.leaderEpoch).setIsr(Replicas.toList(this.isr)).setZkVersion(this.partitionEpoch).setReplicas(Replicas.toList(this.replicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setIsNew(isNew);
    }

    public boolean isReassigning() {
        return this.removingReplicas.length > 0 || this.addingReplicas.length > 0;
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.isr, this.removingReplicas, this.addingReplicas, this.leader, this.leaderEpoch, this.partitionEpoch, this.linkedLeaderEpoch, this.linkState.levelCode);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionRegistration)) {
            return false;
        }
        PartitionRegistration other = (PartitionRegistration)o;
        return Arrays.equals(this.replicas, other.replicas) && Arrays.equals(this.isr, other.isr) && Arrays.equals(this.removingReplicas, other.removingReplicas) && Arrays.equals(this.addingReplicas, other.addingReplicas) && this.leader == other.leader && this.leaderEpoch == other.leaderEpoch && this.partitionEpoch == other.partitionEpoch && this.linkedLeaderEpoch == other.linkedLeaderEpoch && this.linkState == other.linkState;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PartitionRegistration(");
        builder.append("replicas=").append(Arrays.toString(this.replicas));
        builder.append(", isr=").append(Arrays.toString(this.isr));
        builder.append(", removingReplicas=").append(Arrays.toString(this.removingReplicas));
        builder.append(", addingReplicas=").append(Arrays.toString(this.addingReplicas));
        builder.append(", leader=").append(this.leader);
        builder.append(", leaderEpoch=").append(this.leaderEpoch);
        builder.append(", partitionEpoch=").append(this.partitionEpoch);
        builder.append(", linkedLeaderEpoch=").append(this.linkedLeaderEpoch);
        builder.append(", linkState=").append((Object)this.linkState);
        builder.append(")");
        return builder.toString();
    }

    public static enum LinkState {
        FAILED(1),
        ACTIVE(0),
        NOT_SET(-1);

        public final byte levelCode;

        private LinkState(int levelCode) {
            this.levelCode = (byte)levelCode;
        }

        public static LinkState fromCode(int linkState) {
            LinkState value = linkState == 0 ? ACTIVE : (linkState == 1 ? FAILED : NOT_SET);
            return value;
        }
    }
}

