/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicRecord;

public class MirrorTopicState {
    public final Uuid topicId;
    public final String topicName;
    public final String clusterLinkName;
    public final Uuid clusterLinkId;
    public final String sourceTopicName;
    public final Uuid sourceTopicId;
    public final String mirrorTopicState;
    public final String previousToPausedState;
    public final List<Long> stoppedLogEndOffsets;

    public MirrorTopicState(MirrorTopicRecord record) {
        this(record.topicName(), record.topicId(), record.clusterLinkName(), record.clusterLinkId(), record.sourceTopicName(), record.sourceTopicId(), record.mirrorTopicState(), record.previousToPausedState(), record.stoppedLogEndOffsets());
    }

    public MirrorTopicState(String topicName, Uuid topicId, String clusterLinkName, Uuid clusterLinkId, String sourceTopicName, Uuid sourceTopicId, String mirrorTopicState, String previousToPausedState, List<Long> stoppedLogEndOffsets) {
        this.topicName = topicName;
        this.topicId = topicId;
        this.clusterLinkName = clusterLinkName;
        this.clusterLinkId = clusterLinkId;
        this.sourceTopicName = sourceTopicName;
        this.sourceTopicId = sourceTopicId;
        this.mirrorTopicState = mirrorTopicState;
        this.previousToPausedState = previousToPausedState;
        this.stoppedLogEndOffsets = Collections.unmodifiableList(stoppedLogEndOffsets);
    }

    public Optional<String> previousToPausedState() {
        return Optional.ofNullable(this.previousToPausedState);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.topicId, this.clusterLinkName, this.clusterLinkId, this.sourceTopicName, this.sourceTopicId, this.mirrorTopicState, this.previousToPausedState, this.stoppedLogEndOffsets);
    }

    public boolean equals(Object o) {
        boolean otherPreviousToPausedStateNull;
        if (!(o instanceof MirrorTopicState)) {
            return false;
        }
        MirrorTopicState other = (MirrorTopicState)o;
        boolean previousToPausedStateNull = this.previousToPausedState == null;
        boolean bl = otherPreviousToPausedStateNull = other.previousToPausedState == null;
        boolean previousToPausedStateEquals = previousToPausedStateNull && otherPreviousToPausedStateNull ? true : (previousToPausedStateNull ^ otherPreviousToPausedStateNull ? false : this.previousToPausedState.equals(other.previousToPausedState));
        return this.topicName.equals(other.topicName) && this.topicId.equals((Object)other.topicId) && this.clusterLinkName.equals(other.clusterLinkName) && this.clusterLinkId.equals((Object)other.clusterLinkId) && this.sourceTopicName.equals(other.sourceTopicName) && this.sourceTopicId.equals((Object)other.sourceTopicId) && this.mirrorTopicState.equals(other.mirrorTopicState) && this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets) && previousToPausedStateEquals;
    }

    public String toString() {
        return "MirrorTopicState(topicName=" + this.topicName + ", topicId=" + this.topicId.toString() + ", clusterLinkName=" + this.clusterLinkName + ", clusterLinkId=" + this.clusterLinkId.toString() + ", sourceTopicName=" + this.sourceTopicName + ", sourceTopicId=" + this.sourceTopicId.toString() + ", mirrorTopicState=" + this.mirrorTopicState + ", previousToPausedState=" + this.previousToPausedState + ", stoppedLogEndOffsets=" + this.stoppedLogEndOffsets.toString() + ")";
    }
}

