/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.MirrorTopicState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class TopicImage {
    private final String name;
    private final Uuid id;
    private final Map<Integer, PartitionRegistration> partitions;
    private final MirrorTopicState mirrorTopicState;

    public TopicImage(String name, Uuid id, Map<Integer, PartitionRegistration> partitions, MirrorTopicState mirrorTopicState) {
        this.name = name;
        this.id = id;
        this.partitions = partitions;
        this.mirrorTopicState = mirrorTopicState;
    }

    public String name() {
        return this.name;
    }

    public Uuid id() {
        return this.id;
    }

    public Map<Integer, PartitionRegistration> partitions() {
        return this.partitions;
    }

    public Optional<MirrorTopicState> mirrorTopicState() {
        return Optional.ofNullable(this.mirrorTopicState);
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
        batch.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName(this.name).setTopicId(this.id), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        if (this.mirrorTopicState != null) {
            batch.add(new ApiMessageAndVersion((ApiMessage)new MirrorTopicRecord().setClusterLinkName(this.mirrorTopicState.clusterLinkName).setClusterLinkId(this.mirrorTopicState.clusterLinkId).setTopicName(this.name).setTopicId(this.id).setSourceTopicName(this.mirrorTopicState.sourceTopicName).setSourceTopicId(this.mirrorTopicState.sourceTopicId).setMirrorTopicState(this.mirrorTopicState.mirrorTopicState).setPreviousToPausedState(this.mirrorTopicState.previousToPausedState).setStoppedLogEndOffsets(this.mirrorTopicState.stoppedLogEndOffsets), MetadataRecordType.MIRROR_TOPIC_RECORD.highestSupportedVersion()));
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitions.entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration partition = entry.getValue();
            batch.add(partition.toRecord(this.id, partitionId));
        }
        out.accept(batch);
    }

    public boolean equals(Object o) {
        boolean otherMirrorTopicStateNull;
        if (!(o instanceof TopicImage)) {
            return false;
        }
        TopicImage other = (TopicImage)o;
        boolean mirrorTopicStateNull = this.mirrorTopicState == null;
        boolean bl = otherMirrorTopicStateNull = other.mirrorTopicState == null;
        boolean mirrorTopicStateEquals = mirrorTopicStateNull && otherMirrorTopicStateNull ? true : (mirrorTopicStateNull ^ otherMirrorTopicStateNull ? false : this.mirrorTopicState.equals(other.mirrorTopicState));
        return this.name.equals(other.name) && this.id.equals((Object)other.id) && this.partitions.equals(other.partitions) && mirrorTopicStateEquals;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.partitions, this.mirrorTopicState);
    }

    public String toString() {
        String mirrorState = this.mirrorTopicState().map(topicState -> ", mirrorTopicState=" + topicState).orElse("");
        return "TopicImage(name=" + this.name + ", id=" + this.id + ", partitions=" + this.partitions.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + mirrorState + ")";
    }
}

