/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.MirrorTopicState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;

public final class TopicDelta {
    private final TopicImage image;
    private final Map<Integer, PartitionRegistration> partitionChanges = new HashMap<Integer, PartitionRegistration>();
    private MirrorTopicState mirrorTopicStateChange = null;

    public TopicDelta(TopicImage image) {
        this.image = image;
    }

    public TopicImage image() {
        return this.image;
    }

    public Map<Integer, PartitionRegistration> partitionChanges() {
        return this.partitionChanges;
    }

    public String name() {
        return this.image.name();
    }

    public Uuid id() {
        return this.image.id();
    }

    public void replay(PartitionRecord record) {
        this.partitionChanges.put(record.partitionId(), new PartitionRegistration(record));
    }

    public void replay(PartitionChangeRecord record) {
        PartitionRegistration partition = this.partitionChanges.get(record.partitionId());
        if (partition == null && (partition = this.image.partitions().get(record.partitionId())) == null) {
            throw new RuntimeException("Unable to find partition " + record.topicId() + ":" + record.partitionId());
        }
        this.partitionChanges.put(record.partitionId(), partition.merge(record));
    }

    void replay(MirrorTopicRecord record) {
        if (this.mirrorTopicStateChange != null) {
            throw new RuntimeException("Unable to to override mirror topic state.");
        }
        this.mirrorTopicStateChange = new MirrorTopicState(record);
    }

    void replay(MirrorTopicChangeRecord record) {
        if (this.mirrorTopicStateChange != null) {
            this.mirrorTopicStateChange = new MirrorTopicState(this.mirrorTopicStateChange.topicName, this.mirrorTopicStateChange.topicId, this.mirrorTopicStateChange.clusterLinkName, this.mirrorTopicStateChange.clusterLinkId, this.mirrorTopicStateChange.sourceTopicName, this.mirrorTopicStateChange.sourceTopicId, record.mirrorTopicState(), record.previousToPausedState(), record.stoppedLogEndOffsets());
        } else if (this.image.mirrorTopicState().isPresent()) {
            MirrorTopicState state = this.image.mirrorTopicState().get();
            this.mirrorTopicStateChange = new MirrorTopicState(state.topicName, state.topicId, state.clusterLinkName, state.clusterLinkId, state.sourceTopicName, state.sourceTopicId, record.mirrorTopicState(), record.previousToPausedState(), record.stoppedLogEndOffsets());
        }
    }

    public TopicImage apply() {
        HashMap<Integer, PartitionRegistration> newPartitions = new HashMap<Integer, PartitionRegistration>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration changedPartition = this.partitionChanges.get(partitionId);
            if (changedPartition == null) {
                newPartitions.put(partitionId, entry.getValue());
                continue;
            }
            newPartitions.put(partitionId, changedPartition);
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            if (newPartitions.containsKey(entry.getKey())) continue;
            newPartitions.put(entry.getKey(), entry.getValue());
        }
        MirrorTopicState newMirrorTopicState = this.mirrorTopicStateChange != null ? this.mirrorTopicStateChange : (MirrorTopicState)this.image.mirrorTopicState().orElse(null);
        return new TopicImage(this.image.name(), this.image.id(), newPartitions, newMirrorTopicState);
    }

    public LocalReplicaChanges localChanges(int brokerId) {
        HashSet<TopicPartition> deletes = new HashSet<TopicPartition>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> leaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> followers = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            PartitionRegistration prevPartition;
            if (!Replicas.contains(entry.getValue().replicas, brokerId)) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition == null || !Replicas.contains(prevPartition.replicas, brokerId)) continue;
                deletes.add(new TopicPartition(this.name(), entry.getKey().intValue()));
                continue;
            }
            if (entry.getValue().leader == brokerId) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition != null && prevPartition.partitionEpoch == entry.getValue().partitionEpoch) continue;
                leaders.put(new TopicPartition(this.name(), entry.getKey().intValue()), new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue()));
                continue;
            }
            if (entry.getValue().leader == brokerId || !Replicas.contains(entry.getValue().replicas, brokerId) || (prevPartition = this.image.partitions().get(entry.getKey())) != null && prevPartition.partitionEpoch == entry.getValue().partitionEpoch) continue;
            followers.put(new TopicPartition(this.name(), entry.getKey().intValue()), new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue()));
        }
        return new LocalReplicaChanges(deletes, leaders, followers);
    }

    public Optional<MirrorTopicState> mirrorTopicStateChange() {
        return Optional.ofNullable(this.mirrorTopicStateChange);
    }

    public String toString() {
        String mirrorTopicState = this.mirrorTopicStateChange == null ? "" : ", mirrorTopic=" + this.mirrorTopicStateChange;
        return "TopicDelta(partitionChanges=" + this.partitionChanges + mirrorTopicState + ')';
    }
}

