/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class MirrorTopicChangeRecordJsonConverter {
    public static MirrorTopicChangeRecord read(JsonNode _node, short _version) {
        MirrorTopicChangeRecord _object = new MirrorTopicChangeRecord();
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _clusterLinkIdNode = _node.get("clusterLinkId");
        if (_clusterLinkIdNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'clusterLinkId', which is mandatory in version " + _version);
        }
        if (!_clusterLinkIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.clusterLinkId = Uuid.fromString((String)_clusterLinkIdNode.asText());
        JsonNode _timeMsNode = _node.get("timeMs");
        if (_timeMsNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'timeMs', which is mandatory in version " + _version);
        }
        _object.timeMs = MessageUtil.jsonNodeToLong((JsonNode)_timeMsNode, (String)"MirrorTopicChangeRecord");
        JsonNode _mirrorTopicStateNode = _node.get("mirrorTopicState");
        if (_mirrorTopicStateNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'mirrorTopicState', which is mandatory in version " + _version);
        }
        if (!_mirrorTopicStateNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.mirrorTopicState = _mirrorTopicStateNode.asText();
        JsonNode _previousToPausedStateNode = _node.get("previousToPausedState");
        if (_previousToPausedStateNode == null) {
            _object.previousToPausedState = null;
        } else if (_previousToPausedStateNode.isNull()) {
            _object.previousToPausedState = null;
        } else {
            if (!_previousToPausedStateNode.isTextual()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a string type, but got " + _node.getNodeType());
            }
            _object.previousToPausedState = _previousToPausedStateNode.asText();
        }
        JsonNode _stoppedLogEndOffsetsNode = _node.get("stoppedLogEndOffsets");
        if (_stoppedLogEndOffsetsNode == null) {
            _object.stoppedLogEndOffsets = null;
        } else if (_stoppedLogEndOffsetsNode.isNull()) {
            _object.stoppedLogEndOffsets = null;
        } else {
            if (!_stoppedLogEndOffsetsNode.isArray()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Long> _collection = new ArrayList<Long>(_stoppedLogEndOffsetsNode.size());
            _object.stoppedLogEndOffsets = _collection;
            for (JsonNode _element : _stoppedLogEndOffsetsNode) {
                _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"MirrorTopicChangeRecord element"));
            }
        }
        return _object;
    }

    public static JsonNode write(MirrorTopicChangeRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        _node.set("clusterLinkId", (JsonNode)new TextNode(_object.clusterLinkId.toString()));
        _node.set("timeMs", (JsonNode)new LongNode(_object.timeMs));
        _node.set("mirrorTopicState", (JsonNode)new TextNode(_object.mirrorTopicState));
        if (_object.previousToPausedState != null) {
            _node.set("previousToPausedState", (JsonNode)new TextNode(_object.previousToPausedState));
        }
        if (_object.stoppedLogEndOffsets != null) {
            ArrayNode _stoppedLogEndOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Long _element : _object.stoppedLogEndOffsets) {
                _stoppedLogEndOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
            }
            _node.set("stoppedLogEndOffsets", (JsonNode)_stoppedLogEndOffsetsArray);
        }
        return _node;
    }

    public static JsonNode write(MirrorTopicChangeRecord _object, short _version) {
        return MirrorTopicChangeRecordJsonConverter.write(_object, _version, true);
    }
}

