/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metalog;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotReader;

public class MockMetaLogManagerListener
implements RaftClient.Listener<ApiMessageAndVersion> {
    public static final String COMMIT = "COMMIT";
    public static final String LAST_COMMITTED_OFFSET = "LAST_COMMITTED_OFFSET";
    public static final String NEW_LEADER = "NEW_LEADER";
    public static final String RENOUNCE = "RENOUNCE";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String SNAPSHOT = "SNAPSHOT";
    private final int nodeId;
    private final List<String> serializedEvents = new ArrayList<String>();
    private LeaderAndEpoch leaderAndEpoch = new LeaderAndEpoch(OptionalInt.empty(), 0);

    public MockMetaLogManagerListener(int nodeId) {
        this.nodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleCommit(BatchReader<ApiMessageAndVersion> reader) {
        try {
            while (reader.hasNext()) {
                Batch batch = (Batch)reader.next();
                long lastCommittedOffset = batch.lastOffset();
                for (ApiMessageAndVersion messageAndVersion : batch.records()) {
                    ApiMessage message = messageAndVersion.message();
                    StringBuilder bld = new StringBuilder();
                    bld.append(COMMIT).append(" ").append(message.toString());
                    this.serializedEvents.add(bld.toString());
                }
                StringBuilder bld = new StringBuilder();
                bld.append(LAST_COMMITTED_OFFSET).append(" ").append(lastCommittedOffset);
                this.serializedEvents.add(bld.toString());
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleSnapshot(SnapshotReader<ApiMessageAndVersion> reader) {
        long lastCommittedOffset = reader.lastContainedLogOffset();
        try {
            while (reader.hasNext()) {
                Batch batch = reader.next();
                for (ApiMessageAndVersion messageAndVersion : batch.records()) {
                    ApiMessage message = messageAndVersion.message();
                    StringBuilder bld = new StringBuilder();
                    bld.append(SNAPSHOT).append(" ").append(message.toString());
                    this.serializedEvents.add(bld.toString());
                }
                StringBuilder bld = new StringBuilder();
                bld.append(LAST_COMMITTED_OFFSET).append(" ").append(lastCommittedOffset);
                this.serializedEvents.add(bld.toString());
            }
        }
        finally {
            reader.close();
        }
    }

    public synchronized void handleLeaderChange(LeaderAndEpoch newLeaderAndEpoch) {
        LeaderAndEpoch oldLeaderAndEpoch = this.leaderAndEpoch;
        this.leaderAndEpoch = newLeaderAndEpoch;
        if (newLeaderAndEpoch.isLeader(this.nodeId)) {
            StringBuilder bld = new StringBuilder();
            bld.append(NEW_LEADER).append(" ").append(this.nodeId).append(" ").append(newLeaderAndEpoch.epoch());
            this.serializedEvents.add(bld.toString());
        } else if (oldLeaderAndEpoch.isLeader(this.nodeId)) {
            StringBuilder bld = new StringBuilder();
            bld.append(RENOUNCE).append(" ").append(newLeaderAndEpoch.epoch());
            this.serializedEvents.add(bld.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginShutdown() {
        StringBuilder bld = new StringBuilder();
        bld.append(SHUTDOWN);
        MockMetaLogManagerListener mockMetaLogManagerListener = this;
        synchronized (mockMetaLogManagerListener) {
            this.serializedEvents.add(bld.toString());
        }
    }

    public synchronized List<String> serializedEvents() {
        return new ArrayList<String>(this.serializedEvents);
    }
}

