/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import org.apache.kafka.controller.PartitionReassignmentRevert;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentRevertTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionRegistration registration = new PartitionRegistration(new int[]{3, 2, 1}, new int[]{3, 2}, Replicas.NONE, Replicas.NONE, 3, 100, 200);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3, 2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeRemoving() {
        PartitionRegistration registration = new PartitionRegistration(new int[]{3, 2, 1}, new int[]{3, 2}, new int[]{2, 1}, Replicas.NONE, 3, 100, 200);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3, 2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeAdding() {
        PartitionRegistration registration = new PartitionRegistration(new int[]{4, 5, 3, 2, 1}, new int[]{4, 5, 2}, Replicas.NONE, new int[]{4, 5}, 3, 100, 200);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeRemovingAndAdding() {
        PartitionRegistration registration = new PartitionRegistration(new int[]{4, 5, 3, 2, 1}, new int[]{4, 5, 2}, new int[]{2}, new int[]{4, 5}, 3, 100, 200);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testIsrSpecialCase() {
        PartitionRegistration registration = new PartitionRegistration(new int[]{4, 5, 3, 2, 1}, new int[]{4, 5}, new int[]{2}, new int[]{4, 5}, 3, 100, 200);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3), (Object)revert.isr());
        Assertions.assertTrue((boolean)revert.unclean());
    }
}

