/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.controller.ControllerPurgatory;
import org.apache.kafka.controller.DeferredEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ControllerPurgatoryTest {
    @Test
    public void testCompleteEvents() {
        ControllerPurgatory purgatory = new ControllerPurgatory();
        SampleDeferredEvent event1 = new SampleDeferredEvent();
        SampleDeferredEvent event2 = new SampleDeferredEvent();
        SampleDeferredEvent event3 = new SampleDeferredEvent();
        purgatory.add(1L, (DeferredEvent)event1);
        Assertions.assertEquals(Optional.of(1L), (Object)purgatory.highestPendingOffset());
        purgatory.add(1L, (DeferredEvent)event2);
        Assertions.assertEquals(Optional.of(1L), (Object)purgatory.highestPendingOffset());
        purgatory.add(3L, (DeferredEvent)event3);
        Assertions.assertEquals(Optional.of(3L), (Object)purgatory.highestPendingOffset());
        purgatory.completeUpTo(2L);
        Assertions.assertTrue((boolean)event1.future.isDone());
        Assertions.assertTrue((boolean)event2.future.isDone());
        Assertions.assertFalse((boolean)event3.future.isDone());
        purgatory.completeUpTo(4L);
        Assertions.assertTrue((boolean)event3.future.isDone());
        Assertions.assertEquals(Optional.empty(), (Object)purgatory.highestPendingOffset());
    }

    @Test
    public void testFailOnIncorrectOrdering() {
        ControllerPurgatory purgatory = new ControllerPurgatory();
        SampleDeferredEvent event1 = new SampleDeferredEvent();
        SampleDeferredEvent event2 = new SampleDeferredEvent();
        purgatory.add(2L, (DeferredEvent)event1);
        Assertions.assertThrows(RuntimeException.class, () -> purgatory.add(1L, (DeferredEvent)event2));
    }

    @Test
    public void testFailEvents() {
        ControllerPurgatory purgatory = new ControllerPurgatory();
        SampleDeferredEvent event1 = new SampleDeferredEvent();
        SampleDeferredEvent event2 = new SampleDeferredEvent();
        SampleDeferredEvent event3 = new SampleDeferredEvent();
        purgatory.add(1L, (DeferredEvent)event1);
        purgatory.add(3L, (DeferredEvent)event2);
        purgatory.add(3L, (DeferredEvent)event3);
        purgatory.completeUpTo(2L);
        Assertions.assertTrue((boolean)event1.future.isDone());
        Assertions.assertFalse((boolean)event2.future.isDone());
        Assertions.assertFalse((boolean)event3.future.isDone());
        purgatory.failAll((Exception)new RuntimeException("failed"));
        Assertions.assertTrue((boolean)event2.future.isDone());
        Assertions.assertTrue((boolean)event3.future.isDone());
        Assertions.assertEquals(RuntimeException.class, ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)event2.future.get();
        })).getCause().getClass());
        Assertions.assertEquals(RuntimeException.class, ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)event3.future.get();
        })).getCause().getClass());
    }

    static class SampleDeferredEvent
    implements DeferredEvent {
        private final CompletableFuture<Void> future = new CompletableFuture();

        SampleDeferredEvent() {
        }

        public void complete(Throwable exception) {
            if (exception != null) {
                this.future.completeExceptionally(exception);
            } else {
                this.future.complete(null);
            }
        }

        CompletableFuture<Void> future() {
            return this.future;
        }
    }
}

