/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.internals.MemoryBatchReader;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;

public class RecordTestUtils {
    public static void replayAll(Object target, List<ApiMessageAndVersion> recordsAndVersions) {
        for (ApiMessageAndVersion recordAndVersion : recordsAndVersions) {
            ApiMessage record = recordAndVersion.message();
            try {
                Method method = target.getClass().getMethod("replay", record.getClass());
                method.invoke(target, record);
            }
            catch (NoSuchMethodException method) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void replayAll(MetadataDelta delta, long highestOffset, int highestEpoch, List<ApiMessageAndVersion> recordsAndVersions) {
        for (ApiMessageAndVersion recordAndVersion : recordsAndVersions) {
            ApiMessage record = recordAndVersion.message();
            delta.replay(highestOffset, highestEpoch, record);
        }
    }

    public static void replayAllBatches(Object target, List<List<ApiMessageAndVersion>> batches) {
        for (List<ApiMessageAndVersion> batch : batches) {
            RecordTestUtils.replayAll(target, batch);
        }
    }

    public static void replayAllBatches(MetadataDelta delta, long highestOffset, int highestEpoch, List<List<ApiMessageAndVersion>> batches) {
        for (List<ApiMessageAndVersion> batch : batches) {
            RecordTestUtils.replayAll(delta, highestOffset, highestEpoch, batch);
        }
    }

    public static <T> Set<T> iteratorToSet(Iterator<T> iterator) {
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static void assertBatchIteratorContains(List<List<ApiMessageAndVersion>> batches, Iterator<List<ApiMessageAndVersion>> iterator) throws Exception {
        ArrayList actual = new ArrayList();
        while (iterator.hasNext()) {
            actual.add(new ArrayList(iterator.next()));
        }
        RecordTestUtils.deepSortRecords(actual);
        ArrayList<ArrayList<ApiMessageAndVersion>> expected = new ArrayList<ArrayList<ApiMessageAndVersion>>();
        for (List<ApiMessageAndVersion> batch : batches) {
            expected.add(new ArrayList<ApiMessageAndVersion>(batch));
        }
        RecordTestUtils.deepSortRecords(expected);
        Assertions.assertEquals(expected, actual);
    }

    public static void deepSortRecords(Object o) throws Exception {
        if (o == null) {
            return;
        }
        if (o instanceof List) {
            List list = (List)o;
            for (Object entry : list) {
                if (entry == null) continue;
                if (Number.class.isAssignableFrom(entry.getClass())) {
                    return;
                }
                RecordTestUtils.deepSortRecords(entry);
            }
            list.sort(Comparator.comparing(Object::toString));
        } else if (o instanceof ImplicitLinkedHashCollection) {
            ImplicitLinkedHashCollection coll = (ImplicitLinkedHashCollection)o;
            for (Object entry : coll) {
                RecordTestUtils.deepSortRecords(entry);
            }
            coll.sort(Comparator.comparing(Object::toString));
        } else if (o instanceof Message || o instanceof ApiMessageAndVersion) {
            for (Field field : o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                RecordTestUtils.deepSortRecords(field.get(o));
            }
        }
    }

    public static BatchReader<ApiMessageAndVersion> mockBatchReader(long lastOffset, List<ApiMessageAndVersion> records) {
        ArrayList<Batch> batches = new ArrayList<Batch>();
        long offset = lastOffset - (long)records.size() + 1L;
        Iterator<ApiMessageAndVersion> iterator = records.iterator();
        ArrayList<Object> curRecords = new ArrayList<ApiMessageAndVersion>();
        Assertions.assertTrue((boolean)iterator.hasNext());
        while (true) {
            if (!iterator.hasNext() || curRecords.size() >= 2) {
                batches.add(Batch.data((long)offset, (int)0, (long)0L, (int)RecordTestUtils.sizeInBytes(curRecords), curRecords));
                if (!iterator.hasNext()) break;
                offset += (long)curRecords.size();
                curRecords = new ArrayList();
            }
            curRecords.add(iterator.next());
        }
        return MemoryBatchReader.of(batches, __ -> {});
    }

    private static int sizeInBytes(List<ApiMessageAndVersion> records) {
        int size = 0;
        for (ApiMessageAndVersion record : records) {
            ObjectSerializationCache cache = new ObjectSerializationCache();
            size += MetadataRecordSerde.INSTANCE.recordSize(record, cache);
        }
        return size;
    }
}

