/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;

class PartitionReassignmentRevert {
    private final List<Integer> replicas;
    private final List<Integer> isr;
    private final boolean unclean;

    PartitionReassignmentRevert(PartitionRegistration registration) {
        Set<Integer> adding = Replicas.toSet(registration.addingReplicas);
        this.replicas = new ArrayList<Integer>(registration.replicas.length);
        this.isr = new ArrayList<Integer>(registration.isr.length);
        for (int i = 0; i < registration.isr.length; ++i) {
            int replica = registration.isr[i];
            if (adding.contains(replica)) continue;
            this.isr.add(replica);
        }
        for (int replica : registration.replicas) {
            if (adding.contains(replica)) continue;
            this.replicas.add(replica);
        }
        if (this.isr.isEmpty()) {
            if (this.replicas.isEmpty()) {
                throw new InvalidReplicaAssignmentException("Invalid replica assignment: addingReplicas contains all replicas.");
            }
            this.isr.add(this.replicas.get(0));
            this.unclean = true;
        } else {
            this.unclean = false;
        }
    }

    List<Integer> replicas() {
        return this.replicas;
    }

    List<Integer> isr() {
        return this.isr;
    }

    boolean unclean() {
        return this.unclean;
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.isr);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionReassignmentRevert)) {
            return false;
        }
        PartitionReassignmentRevert other = (PartitionReassignmentRevert)o;
        return this.replicas.equals(other.replicas) && this.isr.equals(other.isr);
    }

    public String toString() {
        return "PartitionReassignmentRevert(replicas=" + this.replicas + ", isr=" + this.isr + ")";
    }
}

