/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;

public class ClusterLink {
    private final String linkName;
    private final Uuid linkId;
    private final String tenantPrefix;

    public ClusterLink(String linkName, Uuid linkId, String tenantPrefix) {
        this.linkName = linkName;
        this.linkId = linkId;
        this.tenantPrefix = tenantPrefix;
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Optional<String> tenantPrefix() {
        return Optional.ofNullable(this.tenantPrefix);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLink)) {
            return false;
        }
        ClusterLink other = (ClusterLink)o;
        return this.linkName.equals(other.linkName) && this.linkId.equals((Object)other.linkId) && this.tenantPrefix.equals(other.tenantPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.linkId, this.tenantPrefix);
    }

    public String toString() {
        String tenantPrefixString = this.tenantPrefix != null ? ", tenantPrefix=" + this.tenantPrefix : "";
        return "ClusterLinkImage(linkName=" + this.linkName + ", linkId=" + this.linkId + tenantPrefixString + ")";
    }
}

