/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.TranslatedValueMapView;

public final class TopicsImage {
    public static final TopicsImage EMPTY = new TopicsImage(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private final Map<Uuid, TopicImage> topicsById;
    private final Map<String, TopicImage> topicsByName;
    private final Map<String, Set<String>> topicNamesByTenant;
    private final Map<Uuid, List<TopicImage>> topicsByLinkId;

    public TopicsImage(Map<Uuid, TopicImage> topicsById, Map<String, TopicImage> topicsByName, Map<String, Set<String>> topicNamesByTenant, Map<Uuid, List<TopicImage>> topicsByLinkId) {
        this.topicsById = Collections.unmodifiableMap(topicsById);
        this.topicsByName = Collections.unmodifiableMap(topicsByName);
        this.topicNamesByTenant = Collections.unmodifiableMap(topicNamesByTenant);
        this.topicsByLinkId = Collections.unmodifiableMap(topicsByLinkId);
    }

    public boolean isEmpty() {
        return this.topicsById.isEmpty() && this.topicsByName.isEmpty();
    }

    public Map<Uuid, TopicImage> topicsById() {
        return this.topicsById;
    }

    public Map<String, TopicImage> topicsByName() {
        return this.topicsByName;
    }

    public Set<String> topicsByTenant(String tenant) {
        return this.topicNamesByTenant.getOrDefault(tenant, Collections.emptySet());
    }

    public List<TopicImage> topicsByLinkId(Uuid linkId) {
        return this.topicsByLinkId.getOrDefault(linkId, Collections.emptyList());
    }

    public PartitionRegistration getPartition(Uuid id, int partitionId) {
        TopicImage topicImage = this.topicsById.get(id);
        if (topicImage == null) {
            return null;
        }
        return topicImage.partitions().get(partitionId);
    }

    public TopicImage getTopic(Uuid id) {
        return this.topicsById.get(id);
    }

    public TopicImage getTopic(String name) {
        return this.topicsByName.get(name);
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        for (TopicImage topicImage : this.topicsById.values()) {
            topicImage.write(out);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TopicsImage)) {
            return false;
        }
        TopicsImage other = (TopicsImage)o;
        boolean topicsByLinkIdEqual = true;
        if (this.topicsByLinkId.size() != other.topicsByLinkId.size()) {
            topicsByLinkIdEqual = false;
        } else {
            for (Map.Entry<Uuid, List<TopicImage>> entry : this.topicsByLinkId.entrySet()) {
                List<TopicImage> otherImages;
                Uuid linkID = entry.getKey();
                List<TopicImage> images = entry.getValue();
                if (images.equals(otherImages = other.topicsByLinkId.get(linkID))) continue;
                topicsByLinkIdEqual = false;
                break;
            }
        }
        return this.topicsById.equals(other.topicsById) && this.topicsByName.equals(other.topicsByName) && this.topicNamesByTenant.equals(other.topicNamesByTenant) && topicsByLinkIdEqual;
    }

    public int hashCode() {
        return Objects.hash(this.topicsById, this.topicsByName, this.topicNamesByTenant, this.topicsByLinkId);
    }

    public Map<String, Uuid> topicNameToIdView() {
        return new TranslatedValueMapView(this.topicsByName, image -> image.id());
    }

    public Map<Uuid, String> topicIdToNameView() {
        return new TranslatedValueMapView(this.topicsById, image -> image.name());
    }

    public String toString() {
        String tenantTopicNames = !this.topicNamesByTenant.isEmpty() ? ", topicNamesByTenant=" + this.topicNamesByTenant.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) : "";
        String linkIdTopicNames = !this.topicsByLinkId.isEmpty() ? ", topicsByLinkId=" + this.topicsByLinkId.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) : "";
        return "TopicsImage(topicsById=" + this.topicsById.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + ", topicsByName=" + this.topicsByName.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + tenantTopicNames + linkIdTopicNames + ")";
    }
}

