/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class ClusterLinksImage {
    public static final ClusterLinksImage EMPTY = new ClusterLinksImage(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private final Map<Uuid, ClusterLink> linksById;
    private final Map<String, ClusterLink> linksByName;
    private final Map<String, Set<String>> linkNamesByTenant;

    public ClusterLinksImage(Map<Uuid, ClusterLink> linksById, Map<String, ClusterLink> linksByName, Map<String, Set<String>> linkNamesByTenant) {
        this.linksById = Collections.unmodifiableMap(linksById);
        this.linksByName = Collections.unmodifiableMap(linksByName);
        this.linkNamesByTenant = Collections.unmodifiableMap(linkNamesByTenant);
    }

    public boolean isEmpty() {
        return this.linksById.isEmpty() && this.linksByName.isEmpty();
    }

    public Map<Uuid, ClusterLink> linksById() {
        return this.linksById;
    }

    public Map<String, ClusterLink> linksByName() {
        return this.linksByName;
    }

    public Set<String> linksForTenant(String tenant) {
        return this.linkNamesByTenant.getOrDefault(tenant, Collections.emptySet());
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
        for (ClusterLink link : this.linksById.values()) {
            batch.add(new ApiMessageAndVersion((ApiMessage)new ClusterLinkRecord().setClusterLinkName(link.linkName()).setClusterLinkId(link.linkId()).setTenantPrefix(link.tenantPrefix().orElse(null)), MetadataRecordType.CLUSTER_LINK_RECORD.highestSupportedVersion()));
        }
        out.accept(batch);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLinksImage)) {
            return false;
        }
        ClusterLinksImage other = (ClusterLinksImage)o;
        return this.linksById.equals(other.linksById) && this.linksByName.equals(other.linksByName) && this.linkNamesByTenant.equals(other.linkNamesByTenant);
    }

    public int hashCode() {
        return Objects.hash(this.linksById, this.linksByName, this.linkNamesByTenant);
    }

    public String toString() {
        String tenantLinkNames = !this.linkNamesByTenant.isEmpty() ? ", linkNamesByTenant=" + this.linkNamesByTenant.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) : "";
        return "ClusterLinksImage(linksById=" + this.linksById.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + ", linksByName=" + this.linksByName.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + tenantLinkNames + ")";
    }
}

