/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.metadata.ClusterLink;

public class ClusterLinksDelta {
    private final ClusterLinksImage image;
    private final Map<Uuid, ClusterLink> addedClusterLinks;
    private final Set<Uuid> deletedClusterLinks;

    public ClusterLinksDelta(ClusterLinksImage image) {
        this.image = image;
        this.addedClusterLinks = new HashMap<Uuid, ClusterLink>();
        this.deletedClusterLinks = new HashSet<Uuid>();
    }

    public void replay(ClusterLinkRecord record) {
        this.addedClusterLinks.put(record.clusterLinkId(), new ClusterLink(record.clusterLinkName(), record.clusterLinkId(), record.tenantPrefix()));
    }

    public void replay(RemoveClusterLinkRecord removeRecord) {
        if (this.addedClusterLinks.remove(removeRecord.clusterLinkId()) != null) {
            if (this.image.linksById().containsKey(removeRecord.clusterLinkId())) {
                this.deletedClusterLinks.add(removeRecord.clusterLinkId());
            }
        } else {
            if (!this.image.linksById().containsKey(removeRecord.clusterLinkId())) {
                throw new RuntimeException("Cannot remove unknown ClusterLink " + removeRecord.clusterLinkId());
            }
            this.deletedClusterLinks.add(removeRecord.clusterLinkId());
        }
    }

    public ClusterLinksImage apply() {
        HashMap<String, ClusterLink> newLinksByName = new HashMap<String, ClusterLink>(this.image.linksByName().size());
        HashMap<Uuid, ClusterLink> newLinksById = new HashMap<Uuid, ClusterLink>(this.image.linksById().size());
        this.image.linksById().forEach((linkId, clusterLink) -> {
            if (!this.deletedClusterLinks.contains(linkId)) {
                newLinksByName.put(clusterLink.linkName(), (ClusterLink)clusterLink);
                newLinksById.put((Uuid)linkId, (ClusterLink)clusterLink);
            }
        });
        this.addedClusterLinks.forEach((linkId, clusterLink) -> {
            if (!newLinksById.containsKey(linkId)) {
                newLinksByName.put(clusterLink.linkName(), (ClusterLink)clusterLink);
                newLinksById.put((Uuid)linkId, (ClusterLink)clusterLink);
            }
        });
        return new ClusterLinksImage(newLinksById, newLinksByName, Collections.emptyMap());
    }

    public void finishSnapshot() {
        for (Uuid linkId : this.image.linksById().keySet()) {
            if (this.addedClusterLinks.containsKey(linkId)) continue;
            this.deletedClusterLinks.add(linkId);
        }
    }

    public String toString() {
        return "ClusterLinksDelta(addedClusterLinks=" + this.addedClusterLinks + ", deletedClusterLinks=" + this.deletedClusterLinks + ')';
    }
}

