/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;

public final class ClusterDelta {
    private final ClusterImage image;
    private final HashMap<Integer, Optional<BrokerRegistration>> changedBrokers = new HashMap();

    public ClusterDelta(ClusterImage image) {
        this.image = image;
    }

    public HashMap<Integer, Optional<BrokerRegistration>> changedBrokers() {
        return this.changedBrokers;
    }

    public BrokerRegistration broker(int nodeId) {
        Optional<BrokerRegistration> result = this.changedBrokers.get(nodeId);
        if (result != null) {
            return result.orElse(null);
        }
        return this.image.broker(nodeId);
    }

    private boolean isBrokerAvailable(Optional<BrokerRegistration> registration) {
        return registration.isPresent() && !registration.get().fenced();
    }

    public List<BrokerRegistration> newBrokers() {
        ArrayList<BrokerRegistration> newBrokerList = new ArrayList<BrokerRegistration>();
        for (Optional<BrokerRegistration> newRegistration : this.changedBrokers.values()) {
            Optional<BrokerRegistration> oldRegistration;
            if (!this.isBrokerAvailable(newRegistration) || this.isBrokerAvailable(oldRegistration = Optional.ofNullable(this.image.broker(newRegistration.get().id())))) continue;
            newBrokerList.add(newRegistration.get());
        }
        return newBrokerList;
    }

    public Set<Integer> removedBrokers() {
        HashSet<Integer> removedBrokerSet = new HashSet<Integer>();
        for (Map.Entry<Integer, Optional<BrokerRegistration>> entry : this.changedBrokers.entrySet()) {
            Optional<BrokerRegistration> newRegistration = entry.getValue();
            if (this.isBrokerAvailable(newRegistration) || this.image.broker(entry.getKey()) == null) continue;
            removedBrokerSet.add(entry.getKey());
        }
        return removedBrokerSet;
    }

    public void finishSnapshot() {
        for (Integer brokerId : this.image.brokers().keySet()) {
            if (this.changedBrokers.containsKey(brokerId)) continue;
            this.changedBrokers.put(brokerId, Optional.empty());
        }
    }

    public void replay(RegisterBrokerRecord record) {
        BrokerRegistration broker = BrokerRegistration.fromRecord(record);
        this.changedBrokers.put(broker.id(), Optional.of(broker));
    }

    public void replay(UnregisterBrokerRecord record) {
        this.changedBrokers.put(record.brokerId(), Optional.empty());
    }

    private BrokerRegistration getBrokerOrThrow(int brokerId, long epoch, String action) {
        BrokerRegistration broker = this.broker(brokerId);
        if (broker == null) {
            throw new IllegalStateException("Tried to " + action + " broker " + brokerId + ", but that broker was not registered.");
        }
        if (broker.epoch() != epoch) {
            throw new IllegalStateException("Tried to " + action + " broker " + brokerId + ", but the given epoch, " + epoch + ", did not match the current broker epoch, " + broker.epoch());
        }
        return broker;
    }

    public void replay(FenceBrokerRecord record) {
        BrokerRegistration broker = this.getBrokerOrThrow(record.id(), record.epoch(), "fence");
        this.changedBrokers.put(record.id(), Optional.of(broker.cloneWithFencing(true)));
    }

    public void replay(UnfenceBrokerRecord record) {
        BrokerRegistration broker = this.getBrokerOrThrow(record.id(), record.epoch(), "unfence");
        this.changedBrokers.put(record.id(), Optional.of(broker.cloneWithFencing(false)));
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        BrokerRegistration broker = this.getBrokerOrThrow(record.brokerId(), record.brokerEpoch(), "change");
        if (record.fenced() < 0) {
            this.changedBrokers.put(record.brokerId(), Optional.of(broker.cloneWithFencing(false)));
        } else if (record.fenced() > 0) {
            this.changedBrokers.put(record.brokerId(), Optional.of(broker.cloneWithFencing(true)));
        }
    }

    public ClusterImage apply() {
        int nodeId;
        HashMap<Integer, BrokerRegistration> newBrokers = new HashMap<Integer, BrokerRegistration>(this.image.brokers().size());
        for (Map.Entry<Integer, BrokerRegistration> entry : this.image.brokers().entrySet()) {
            nodeId = entry.getKey();
            Optional<BrokerRegistration> change = this.changedBrokers.get(nodeId);
            if (change == null) {
                newBrokers.put(nodeId, entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newBrokers.put(nodeId, change.get());
        }
        for (Map.Entry<Integer, Object> entry : this.changedBrokers.entrySet()) {
            nodeId = entry.getKey();
            Optional brokerRegistration = (Optional)entry.getValue();
            if (newBrokers.containsKey(nodeId) || !brokerRegistration.isPresent()) continue;
            newBrokers.put(nodeId, (BrokerRegistration)brokerRegistration.get());
        }
        return new ClusterImage(newBrokers);
    }

    public String toString() {
        return "ClusterDelta(changedBrokers=" + this.changedBrokers + ')';
    }
}

