/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class MirrorTopicRecordJsonConverter {
    public static MirrorTopicRecord read(JsonNode _node, short _version) {
        MirrorTopicRecord _object = new MirrorTopicRecord();
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _topicNameNode = _node.get("topicName");
        if (_topicNameNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'topicName', which is mandatory in version " + _version);
        }
        if (!_topicNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.topicName = _topicNameNode.asText();
        JsonNode _clusterLinkNameNode = _node.get("clusterLinkName");
        if (_clusterLinkNameNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'clusterLinkName', which is mandatory in version " + _version);
        }
        if (!_clusterLinkNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.clusterLinkName = _clusterLinkNameNode.asText();
        JsonNode _clusterLinkIdNode = _node.get("clusterLinkId");
        if (_clusterLinkIdNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'clusterLinkId', which is mandatory in version " + _version);
        }
        if (!_clusterLinkIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.clusterLinkId = Uuid.fromString((String)_clusterLinkIdNode.asText());
        JsonNode _sourceTopicNameNode = _node.get("sourceTopicName");
        if (_sourceTopicNameNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'sourceTopicName', which is mandatory in version " + _version);
        }
        if (!_sourceTopicNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.sourceTopicName = _sourceTopicNameNode.asText();
        JsonNode _sourceTopicIdNode = _node.get("sourceTopicId");
        if (_sourceTopicIdNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'sourceTopicId', which is mandatory in version " + _version);
        }
        if (!_sourceTopicIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.sourceTopicId = Uuid.fromString((String)_sourceTopicIdNode.asText());
        JsonNode _mirrorTopicStateNode = _node.get("mirrorTopicState");
        if (_mirrorTopicStateNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'mirrorTopicState', which is mandatory in version " + _version);
        }
        if (!_mirrorTopicStateNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.mirrorTopicState = _mirrorTopicStateNode.asText();
        JsonNode _previousToPausedStateNode = _node.get("previousToPausedState");
        if (_previousToPausedStateNode == null) {
            _object.previousToPausedState = null;
        } else if (_previousToPausedStateNode.isNull()) {
            _object.previousToPausedState = null;
        } else {
            if (!_previousToPausedStateNode.isTextual()) {
                throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
            }
            _object.previousToPausedState = _previousToPausedStateNode.asText();
        }
        JsonNode _stoppedLogEndOffsetsNode = _node.get("stoppedLogEndOffsets");
        if (_stoppedLogEndOffsetsNode == null) {
            _object.stoppedLogEndOffsets = null;
        } else if (_stoppedLogEndOffsetsNode.isNull()) {
            _object.stoppedLogEndOffsets = null;
        } else {
            if (!_stoppedLogEndOffsetsNode.isArray()) {
                throw new RuntimeException("MirrorTopicRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Long> _collection = new ArrayList<Long>(_stoppedLogEndOffsetsNode.size());
            _object.stoppedLogEndOffsets = _collection;
            for (JsonNode _element : _stoppedLogEndOffsetsNode) {
                _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"MirrorTopicRecord element"));
            }
        }
        return _object;
    }

    public static JsonNode write(MirrorTopicRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
        _node.set("clusterLinkName", (JsonNode)new TextNode(_object.clusterLinkName));
        _node.set("clusterLinkId", (JsonNode)new TextNode(_object.clusterLinkId.toString()));
        _node.set("sourceTopicName", (JsonNode)new TextNode(_object.sourceTopicName));
        _node.set("sourceTopicId", (JsonNode)new TextNode(_object.sourceTopicId.toString()));
        _node.set("mirrorTopicState", (JsonNode)new TextNode(_object.mirrorTopicState));
        if (_object.previousToPausedState != null) {
            _node.set("previousToPausedState", (JsonNode)new TextNode(_object.previousToPausedState));
        }
        if (_object.stoppedLogEndOffsets != null) {
            ArrayNode _stoppedLogEndOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Long _element : _object.stoppedLogEndOffsets) {
                _stoppedLogEndOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
            }
            _node.set("stoppedLogEndOffsets", (JsonNode)_stoppedLogEndOffsetsArray);
        }
        return _node;
    }

    public static JsonNode write(MirrorTopicRecord _object, short _version) {
        return MirrorTopicRecordJsonConverter.write(_object, _version, true);
    }
}

