/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionRegistrationTest {
    @Test
    public void testElectionWasClean() {
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{1, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{0, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[0]));
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)3, (int[])new int[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void testPartitionControlInfoMergeAndDiff() {
        PartitionRegistration a = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2}, Replicas.NONE, Replicas.NONE, 1, 0, 0);
        PartitionRegistration b = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{3}, Replicas.NONE, Replicas.NONE, 3, 1, 1);
        PartitionRegistration c = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1}, Replicas.NONE, Replicas.NONE, 1, 0, 1);
        Assertions.assertEquals((Object)b, (Object)a.merge(new PartitionChangeRecord().setLeader(3).setIsr(Arrays.asList(3))));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [3], leader: 1 -> 3, leaderEpoch: 0 -> 1, partitionEpoch: 0 -> 1", (Object)b.diff(a));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [1], partitionEpoch: 0 -> 1", (Object)c.diff(a));
    }

    @Test
    public void testRecordRoundTrip() {
        PartitionRegistration registrationA = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2}, new int[]{1}, Replicas.NONE, 1, 0, 0);
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        ApiMessageAndVersion record = registrationA.toRecord(topicId, partitionId);
        PartitionRegistration registrationB = new PartitionRegistration((PartitionRecord)record.message());
        Assertions.assertEquals((Object)registrationA, (Object)registrationB);
    }

    @Test
    public void testToLeaderAndIsrPartitionState() {
        Uuid fooId = Uuid.fromString((String)"ALPqMJr3sd-m_Txn5IAdGO");
        Uuid barId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        PartitionRegistration a = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2}, Replicas.NONE, Replicas.NONE, 1, 123, 456);
        PartitionRegistration b = new PartitionRegistration(new int[]{2, 3, 4}, new int[]{2, 3, 4}, Replicas.NONE, Replicas.NONE, 2, 234, 567);
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setTopicId(fooId).setPartitionIndex(1).setControllerEpoch(-1).setLeader(1).setLeaderEpoch(123).setIsr(Arrays.asList(1, 2)).setZkVersion(456).setReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(true).toString(), (Object)a.toLeaderAndIsrPartitionState(new TopicIdPartition(fooId, new TopicPartition("foo", 1)), true).toString());
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("bar").setTopicId(barId).setPartitionIndex(0).setControllerEpoch(-1).setLeader(2).setLeaderEpoch(234).setIsr(Arrays.asList(2, 3, 4)).setZkVersion(567).setReplicas(Arrays.asList(2, 3, 4)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(false).toString(), (Object)b.toLeaderAndIsrPartitionState(new TopicIdPartition(barId, new TopicPartition("bar", 0)), false).toString());
    }

    @Test
    public void testMergePartitionChangeRecordWithReassignmentData() {
        PartitionRegistration partition0 = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 200);
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setRemovingReplicas(Collections.singletonList(3)).setAddingReplicas(Collections.singletonList(4)).setReplicas(Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3, 4}, new int[]{1, 2, 3}, new int[]{3}, new int[]{4}, 1, 100, 201), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setIsr(Arrays.asList(1, 2, 4)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setReplicas(Arrays.asList(1, 2, 4)));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 4}, new int[]{1, 2, 4}, Replicas.NONE, Replicas.NONE, 1, 100, 202), (Object)partition2);
        Assertions.assertFalse((boolean)partition2.isReassigning());
    }

    @Test
    public void testMergePartitionChangeRecordWithNoChange() {
        PartitionRegistration partition0 = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 200, -1, 0);
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(10).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 201, 10, 1), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_SET.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 202, 10, 1), (Object)partition2);
        PartitionRegistration partition3 = partition2.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(20).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 203, 20, 0), (Object)partition3);
        PartitionRegistration partition4 = partition3.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(30).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 204, 30, 0), (Object)partition4);
        PartitionRegistration partition5 = partition4.merge(new PartitionChangeRecord());
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 204, 30, 0), (Object)partition4);
    }

    @Test
    public void testMergePartitionChangeRecordWithClusterLinkData() {
        PartitionRegistration partition0 = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 200, -1, 0);
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(10).setLinkState((byte)1));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 201, 10, 1), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(20).setLinkState((byte)0));
        Assertions.assertEquals((Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 202, 20, 0), (Object)partition2);
    }

    @Test
    public void testClusterLinkDataPropogatesToPartitionRecord() {
        PartitionRegistration partition0 = new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, Replicas.NONE, Replicas.NONE, -1, -1, -1, 10, 1);
        PartitionRecord record = (PartitionRecord)partition0.toRecord(Uuid.ZERO_UUID, 5).message();
        Assertions.assertEquals((Object)new PartitionRecord().setTopicId(Uuid.ZERO_UUID).setPartitionId(5).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLinkedLeaderEpoch(10).setLinkState((byte)1), (Object)record);
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(50).setLinkState((byte)0));
        record = (PartitionRecord)partition1.toRecord(Uuid.ZERO_UUID, 5).message();
        Assertions.assertEquals((Object)new PartitionRecord().setTopicId(Uuid.ZERO_UUID).setPartitionId(5).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setPartitionEpoch(0).setLinkedLeaderEpoch(50).setLinkState((byte)0), (Object)record);
    }
}

