/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ClusterLinksDelta;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.MockSnapshotConsumer;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClusterLinksImageTest {
    static final ClusterLinksImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ClusterLinksDelta DELTA1;
    static final ClusterLinksImage IMAGE2;
    static final List<ClusterLink> CLUSTER_LINKS;
    private static final Uuid FOO_UUID;
    private static final Uuid BAR_UUID;
    private static final Uuid BAZ_UUID;
    private static final Uuid TOPIC_UUID_1;
    private static final Uuid TOPIC_UUID_2;

    private static ClusterLink newClusterLink(String linkName, Uuid linkId, String tenantPrefix) {
        return new ClusterLink(linkName, linkId, tenantPrefix);
    }

    private static Map<Uuid, ClusterLink> newLinksByIdMap(Collection<ClusterLink> links) {
        HashMap<Uuid, ClusterLink> map = new HashMap<Uuid, ClusterLink>();
        for (ClusterLink link : links) {
            map.put(link.linkId(), link);
        }
        return map;
    }

    private static Map<String, ClusterLink> newLinksByNameMap(Collection<ClusterLink> links) {
        HashMap<String, ClusterLink> map = new HashMap<String, ClusterLink>();
        for (ClusterLink link : links) {
            map.put(link.linkName(), link);
        }
        return map;
    }

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(ClusterLinksImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(ClusterLinksImage image) throws Throwable {
        MockSnapshotConsumer writer = new MockSnapshotConsumer();
        image.write((Consumer)writer);
        ClusterLinksDelta delta = new ClusterLinksDelta(ClusterLinksImage.EMPTY);
        RecordTestUtils.replayAllBatches(delta, writer.batches());
        ClusterLinksImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    static {
        FOO_UUID = Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA");
        BAR_UUID = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        BAZ_UUID = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        TOPIC_UUID_1 = Uuid.fromString((String)"ThIaNwRnSM2N8SL5ZeREiw");
        TOPIC_UUID_2 = Uuid.fromString((String)"8SL5ZeREiwThIaNwRnSM2N");
        CLUSTER_LINKS = Arrays.asList(ClusterLinksImageTest.newClusterLink("foo", FOO_UUID, ""), ClusterLinksImageTest.newClusterLink("bar", BAR_UUID, ""));
        IMAGE1 = new ClusterLinksImage(ClusterLinksImageTest.newLinksByIdMap(CLUSTER_LINKS), ClusterLinksImageTest.newLinksByNameMap(CLUSTER_LINKS), Collections.emptyMap());
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkId(FOO_UUID), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ClusterLinkRecord().setClusterLinkName("baz").setClusterLinkId(BAZ_UUID).setTenantPrefix(""), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        DELTA1 = new ClusterLinksDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        List<ClusterLink> clusterLinks2 = Arrays.asList(ClusterLinksImageTest.newClusterLink("bar", BAR_UUID, ""), ClusterLinksImageTest.newClusterLink("baz", BAZ_UUID, ""));
        IMAGE2 = new ClusterLinksImage(ClusterLinksImageTest.newLinksByIdMap(clusterLinks2), ClusterLinksImageTest.newLinksByNameMap(clusterLinks2), Collections.emptyMap());
    }
}

