/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.PartitionChangeBuilder;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.controller.PartitionReassignmentRevert;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionChangeBuilderTest {
    private static final PartitionRegistration FOO = new PartitionRegistration(new int[]{2, 1, 3}, new int[]{2, 1, 3}, Replicas.NONE, Replicas.NONE, 1, 100, 200);
    private static final Uuid FOO_ID = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
    private static final PartitionRegistration BAR = new PartitionRegistration(new int[]{1, 2, 3, 4}, new int[]{1, 2, 3}, new int[]{1}, new int[]{4}, 1, 100, 200);
    private static final Uuid BAR_ID = Uuid.fromString((String)"LKfUsCBnQKekvL9O5dY9nw");

    @Test
    public void testChangeRecordIsNoOp() {
        Assertions.assertTrue((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord()));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLeader(1)));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setIsr(Arrays.asList(1, 2, 3))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setRemovingReplicas(Arrays.asList(1))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setAddingReplicas(Arrays.asList(4))));
    }

    private static PartitionChangeBuilder createFooBuilder(boolean allowUnclean) {
        return new PartitionChangeBuilder(FOO, FOO_ID, 0, r -> r != 3, () -> allowUnclean);
    }

    private static PartitionChangeBuilder createBarBuilder(boolean allowUnclean) {
        return new PartitionChangeBuilder(BAR, BAR_ID, 0, r -> r != 3, () -> allowUnclean);
    }

    private static void assertBestLeaderEquals(PartitionChangeBuilder builder, int expectedNode, boolean expectedUnclean) {
        PartitionChangeBuilder.BestLeader bestLeader = new PartitionChangeBuilder.BestLeader(builder);
        Assertions.assertEquals((int)expectedNode, (int)bestLeader.node);
        Assertions.assertEquals((Object)expectedUnclean, (Object)bestLeader.unclean);
    }

    @Test
    public void testBestLeader() {
        PartitionChangeBuilderTest.assertBestLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(false), 2, false);
        PartitionChangeBuilderTest.assertBestLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(true), 2, false);
        PartitionChangeBuilderTest.assertBestLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(1, 3)), 1, false);
        PartitionChangeBuilderTest.assertBestLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(true).setTargetIsr(Arrays.asList(1, 3)), 1, false);
        PartitionChangeBuilderTest.assertBestLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(3)), -1, false);
        PartitionChangeBuilderTest.assertBestLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(true).setTargetIsr(Arrays.asList(3)), 2, true);
        PartitionChangeBuilderTest.assertBestLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(true).setTargetIsr(Arrays.asList(4)).setTargetReplicas(Arrays.asList(2, 1, 3, 4)), 4, false);
    }

    @Test
    public void testShouldTryElection() {
        Assertions.assertFalse((boolean)PartitionChangeBuilderTest.createFooBuilder(false).shouldTryElection());
        Assertions.assertTrue((boolean)PartitionChangeBuilderTest.createFooBuilder(false).setAlwaysElectPreferredIfPossible(true).shouldTryElection());
        Assertions.assertTrue((boolean)PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(2, 3)).shouldTryElection());
        Assertions.assertFalse((boolean)PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(2, 1)).shouldTryElection());
        Assertions.assertTrue((boolean)PartitionChangeBuilderTest.createFooBuilder(true).setTargetIsr(Arrays.asList(3)).shouldTryElection());
        Assertions.assertTrue((boolean)PartitionChangeBuilderTest.createFooBuilder(true).setTargetIsr(Arrays.asList(4)).setTargetReplicas(Arrays.asList(2, 1, 3, 4)).shouldTryElection());
    }

    private static void testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilder builder, PartitionChangeRecord record, int expectedLeader) {
        builder.triggerLeaderEpochBumpIfNeeded(record);
        Assertions.assertEquals((int)expectedLeader, (int)record.leader());
    }

    @Test
    public void testTriggerLeaderEpochBumpIfNeeded() {
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder(false), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(2, 1)), new PartitionChangeRecord(), 1);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder(false).setTargetReplicas(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder(false).setTargetReplicas(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord().setLeader(2), 2);
    }

    @Test
    public void testNoChange() {
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder(false).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder(true).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder(false).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder(true).build());
    }

    @Test
    public void testIsrChangeAndLeaderBump() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2, 1)).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(2, 1)).build());
    }

    @Test
    public void testIsrChangeAndLeaderChange() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2, 3)).setLeader(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder(false).setTargetIsr(Arrays.asList(2, 3)).build());
    }

    @Test
    public void testReassignmentRearrangesReplicas() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder(false).setTargetReplicas(Arrays.asList(3, 2, 1)).build());
    }

    @Test
    public void testIsrEnlargementCompletesReassignment() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(Arrays.asList(2, 3, 4)).setIsr(Arrays.asList(2, 3, 4)).setLeader(2).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createBarBuilder(false).setTargetIsr(Arrays.asList(1, 2, 3, 4)).build());
    }

    @Test
    public void testRevertReassignment() {
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(BAR);
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)revert.isr());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2, 3)).setLeader(1).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createBarBuilder(false).setTargetReplicas(revert.replicas()).setTargetIsr(revert.isr()).setTargetRemoving(Collections.emptyList()).setTargetAdding(Collections.emptyList()).build());
    }

    @Test
    public void testRemovingReplicaReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas), Arrays.asList(1, 2));
        Assertions.assertEquals(Collections.singletonList(3), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)replicas.merged());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2)).setIsr(Arrays.asList(2, 1)).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder(false).setTargetReplicas(replicas.merged()).setTargetRemoving(replicas.removing()).build());
    }

    @Test
    public void testAddingReplicaReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas), Arrays.asList(1, 2, 3, 4));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.singletonList(4), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)replicas.merged());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2, 3, 4)).setAddingReplicas(Collections.singletonList(4)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder(false).setTargetReplicas(replicas.merged()).setTargetAdding(replicas.adding()).build());
    }

    @Test
    public void testAddingLinkedLeaderEpochAndLinkFailed() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(32).setLinkState((byte)1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder(false).setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(32).setLinkFailed(true).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(64).setLinkState((byte)0), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder(false).setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(64).setLinkFailed(false).build());
    }
}

