/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class MirrorTopicRecord
implements ApiMessage {
    Uuid topicId;
    String topicName;
    String clusterLinkName;
    Uuid clusterLinkId;
    String sourceTopicName;
    Uuid sourceTopicId;
    String mirrorTopicState;
    String previousToPausedState;
    List<Long> stoppedLogEndOffsets;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The unique ID of this mirror topic."), new Field("topic_name", (Type)Type.COMPACT_STRING, "The name of this mirror topic."), new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of the cluster link associated with this mirror topic."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("source_topic_name", (Type)Type.COMPACT_STRING, "The name of the source topic for this mirror topic."), new Field("source_topic_id", (Type)Type.UUID, "The unique ID of the source topic for this mirror topic."), new Field("mirror_topic_state", (Type)Type.COMPACT_STRING, "The new state of the mirror topic. Valid States: Mirror, FailedMirror, PendingStoppedMirror, PausedMirror and StoppedMirror"), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("previous_to_paused_state", (Type)Type.COMPACT_NULLABLE_STRING, "The state this mirror topic will go into if unpaused. Null if mirror topic is not paused."), 1, new Field("stopped_log_end_offsets", (Type)CompactArrayOf.nullable((Type)Type.INT64), "List of log end offsets ordered by partition ids that the mirror topic was stopped at if mirror topic was state. Null if mirror topic is not stopped.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public MirrorTopicRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public MirrorTopicRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public MirrorTopicRecord() {
        this.topicId = Uuid.ZERO_UUID;
        this.topicName = "";
        this.clusterLinkName = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.sourceTopicName = "";
        this.sourceTopicId = Uuid.ZERO_UUID;
        this.mirrorTopicState = "";
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
    }

    public short apiKey() {
        return 10001;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.topicId = _readable.readUuid();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field topicName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field topicName had invalid length " + length);
        }
        this.topicName = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterLinkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterLinkName had invalid length " + length);
        }
        this.clusterLinkName = _readable.readString(length);
        this.clusterLinkId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field sourceTopicName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field sourceTopicName had invalid length " + length);
        }
        this.sourceTopicName = _readable.readString(length);
        this.sourceTopicId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field mirrorTopicState was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field mirrorTopicState had invalid length " + length);
        }
        this.mirrorTopicState = _readable.readString(length);
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.previousToPausedState = null;
                        continue block4;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field previousToPausedState had invalid length " + length2);
                    }
                    this.previousToPausedState = _readable.readString(length2);
                    continue block4;
                }
                case 1: {
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.stoppedLogEndOffsets = null;
                        continue block4;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.stoppedLogEndOffsets = newCollection;
                    continue block4;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.topicId);
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.topicName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.clusterLinkName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeUuid(this.clusterLinkId);
        _stringBytes = _cache.getSerializedValue((Object)this.sourceTopicName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeUuid(this.sourceTopicId);
        _stringBytes = _cache.getSerializedValue((Object)this.mirrorTopicState);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.previousToPausedState != null) {
            _writable.writeUnsignedVarint(0);
            byte[] _stringBytes2 = _cache.getSerializedValue((Object)this.previousToPausedState);
            _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
        }
        if (this.stoppedLogEndOffsets != null) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.stoppedLogEndOffsets).intValue());
            _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
            for (Long stoppedLogEndOffsetsElement : this.stoppedLogEndOffsets) {
                _writable.writeLong(stoppedLogEndOffsetsElement.longValue());
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'topicName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.topicName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.clusterLinkName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterLinkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterLinkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        _stringBytes = this.sourceTopicName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'sourceTopicName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.sourceTopicName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        _stringBytes = this.mirrorTopicState.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'mirrorTopicState' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.mirrorTopicState, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.previousToPausedState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'previousToPausedState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.previousToPausedState, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.stoppedLogEndOffsets.size() + 1)));
            _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.stoppedLogEndOffsets, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MirrorTopicRecord)) {
            return false;
        }
        MirrorTopicRecord other = (MirrorTopicRecord)obj;
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
            return false;
        }
        if (this.clusterLinkName == null ? other.clusterLinkName != null : !this.clusterLinkName.equals(other.clusterLinkName)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.sourceTopicName == null ? other.sourceTopicName != null : !this.sourceTopicName.equals(other.sourceTopicName)) {
            return false;
        }
        if (!this.sourceTopicId.equals((Object)other.sourceTopicId)) {
            return false;
        }
        if (this.mirrorTopicState == null ? other.mirrorTopicState != null : !this.mirrorTopicState.equals(other.mirrorTopicState)) {
            return false;
        }
        if (this.previousToPausedState == null ? other.previousToPausedState != null : !this.previousToPausedState.equals(other.previousToPausedState)) {
            return false;
        }
        if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
        hashCode = 31 * hashCode + (this.clusterLinkName == null ? 0 : this.clusterLinkName.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.sourceTopicName == null ? 0 : this.sourceTopicName.hashCode());
        hashCode = 31 * hashCode + this.sourceTopicId.hashCode();
        hashCode = 31 * hashCode + (this.mirrorTopicState == null ? 0 : this.mirrorTopicState.hashCode());
        hashCode = 31 * hashCode + (this.previousToPausedState == null ? 0 : this.previousToPausedState.hashCode());
        hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
        return hashCode;
    }

    public MirrorTopicRecord duplicate() {
        MirrorTopicRecord _duplicate = new MirrorTopicRecord();
        _duplicate.topicId = this.topicId;
        _duplicate.topicName = this.topicName;
        _duplicate.clusterLinkName = this.clusterLinkName;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.sourceTopicName = this.sourceTopicName;
        _duplicate.sourceTopicId = this.sourceTopicId;
        _duplicate.mirrorTopicState = this.mirrorTopicState;
        _duplicate.previousToPausedState = this.previousToPausedState == null ? null : this.previousToPausedState;
        if (this.stoppedLogEndOffsets == null) {
            _duplicate.stoppedLogEndOffsets = null;
        } else {
            ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
            for (Long _element : this.stoppedLogEndOffsets) {
                newStoppedLogEndOffsets.add(_element);
            }
            _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
        }
        return _duplicate;
    }

    public String toString() {
        return "MirrorTopicRecord(topicId=" + this.topicId.toString() + ", topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", clusterLinkName=" + (this.clusterLinkName == null ? "null" : "'" + this.clusterLinkName.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ", sourceTopicName=" + (this.sourceTopicName == null ? "null" : "'" + this.sourceTopicName.toString() + "'") + ", sourceTopicId=" + this.sourceTopicId.toString() + ", mirrorTopicState=" + (this.mirrorTopicState == null ? "null" : "'" + this.mirrorTopicState.toString() + "'") + ", previousToPausedState=" + (this.previousToPausedState == null ? "null" : "'" + this.previousToPausedState.toString() + "'") + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ")";
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topicName() {
        return this.topicName;
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String sourceTopicName() {
        return this.sourceTopicName;
    }

    public Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public String mirrorTopicState() {
        return this.mirrorTopicState;
    }

    public String previousToPausedState() {
        return this.previousToPausedState;
    }

    public List<Long> stoppedLogEndOffsets() {
        return this.stoppedLogEndOffsets;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MirrorTopicRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public MirrorTopicRecord setTopicName(String v) {
        this.topicName = v;
        return this;
    }

    public MirrorTopicRecord setClusterLinkName(String v) {
        this.clusterLinkName = v;
        return this;
    }

    public MirrorTopicRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public MirrorTopicRecord setSourceTopicName(String v) {
        this.sourceTopicName = v;
        return this;
    }

    public MirrorTopicRecord setSourceTopicId(Uuid v) {
        this.sourceTopicId = v;
        return this;
    }

    public MirrorTopicRecord setMirrorTopicState(String v) {
        this.mirrorTopicState = v;
        return this;
    }

    public MirrorTopicRecord setPreviousToPausedState(String v) {
        this.previousToPausedState = v;
        return this;
    }

    public MirrorTopicRecord setStoppedLogEndOffsets(List<Long> v) {
        this.stoppedLogEndOffsets = v;
        return this;
    }
}

