/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class MirrorTopicChangeRecord
implements ApiMessage {
    Uuid topicId;
    Uuid clusterLinkId;
    long timeMs;
    String mirrorTopicState;
    String previousToPausedState;
    List<Long> stoppedLogEndOffsets;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The unique ID for this mirror topic."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("time_ms", (Type)Type.INT64, "The epoch time at which the state change occurred."), new Field("mirror_topic_state", (Type)Type.COMPACT_STRING, "The new state of the mirror topic. Valid States: Mirror, FailedMirror, PendingStoppedMirror, PausedMirror and StoppedMirror"), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("previous_to_paused_state", (Type)Type.COMPACT_NULLABLE_STRING, "The state this mirror topic will go into if unpaused. Null if mirror topic is not paused."), 1, new Field("stopped_log_end_offsets", (Type)CompactArrayOf.nullable((Type)Type.INT64), "List of log end offsets ordered by partition ids that the mirror topic was stopped at if mirror topic was state. Null if mirror topic is not stopped.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public MirrorTopicChangeRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public MirrorTopicChangeRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public MirrorTopicChangeRecord() {
        this.topicId = Uuid.ZERO_UUID;
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.timeMs = 0L;
        this.mirrorTopicState = "";
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
    }

    public short apiKey() {
        return 10002;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.topicId = _readable.readUuid();
        this.clusterLinkId = _readable.readUuid();
        this.timeMs = _readable.readLong();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field mirrorTopicState was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field mirrorTopicState had invalid length " + length);
        }
        this.mirrorTopicState = _readable.readString(length);
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.previousToPausedState = null;
                        continue block4;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field previousToPausedState had invalid length " + length2);
                    }
                    this.previousToPausedState = _readable.readString(length2);
                    continue block4;
                }
                case 1: {
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.stoppedLogEndOffsets = null;
                        continue block4;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.stoppedLogEndOffsets = newCollection;
                    continue block4;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.topicId);
        _writable.writeUuid(this.clusterLinkId);
        _writable.writeLong(this.timeMs);
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.mirrorTopicState);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.previousToPausedState != null) {
            _writable.writeUnsignedVarint(0);
            byte[] _stringBytes2 = _cache.getSerializedValue((Object)this.previousToPausedState);
            _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
        }
        if (this.stoppedLogEndOffsets != null) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.stoppedLogEndOffsets).intValue());
            _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
            for (Long stoppedLogEndOffsetsElement : this.stoppedLogEndOffsets) {
                _writable.writeLong(stoppedLogEndOffsetsElement.longValue());
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        _size.addBytes(16);
        _size.addBytes(8);
        byte[] _stringBytes = this.mirrorTopicState.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'mirrorTopicState' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.mirrorTopicState, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.previousToPausedState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'previousToPausedState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.previousToPausedState, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.stoppedLogEndOffsets.size() + 1)));
            _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.stoppedLogEndOffsets, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MirrorTopicChangeRecord)) {
            return false;
        }
        MirrorTopicChangeRecord other = (MirrorTopicChangeRecord)obj;
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.timeMs != other.timeMs) {
            return false;
        }
        if (this.mirrorTopicState == null ? other.mirrorTopicState != null : !this.mirrorTopicState.equals(other.mirrorTopicState)) {
            return false;
        }
        if (this.previousToPausedState == null ? other.previousToPausedState != null : !this.previousToPausedState.equals(other.previousToPausedState)) {
            return false;
        }
        if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + ((int)(this.timeMs >> 32) ^ (int)this.timeMs);
        hashCode = 31 * hashCode + (this.mirrorTopicState == null ? 0 : this.mirrorTopicState.hashCode());
        hashCode = 31 * hashCode + (this.previousToPausedState == null ? 0 : this.previousToPausedState.hashCode());
        hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
        return hashCode;
    }

    public MirrorTopicChangeRecord duplicate() {
        MirrorTopicChangeRecord _duplicate = new MirrorTopicChangeRecord();
        _duplicate.topicId = this.topicId;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.timeMs = this.timeMs;
        _duplicate.mirrorTopicState = this.mirrorTopicState;
        _duplicate.previousToPausedState = this.previousToPausedState == null ? null : this.previousToPausedState;
        if (this.stoppedLogEndOffsets == null) {
            _duplicate.stoppedLogEndOffsets = null;
        } else {
            ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
            for (Long _element : this.stoppedLogEndOffsets) {
                newStoppedLogEndOffsets.add(_element);
            }
            _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
        }
        return _duplicate;
    }

    public String toString() {
        return "MirrorTopicChangeRecord(topicId=" + this.topicId.toString() + ", clusterLinkId=" + this.clusterLinkId.toString() + ", timeMs=" + this.timeMs + ", mirrorTopicState=" + (this.mirrorTopicState == null ? "null" : "'" + this.mirrorTopicState.toString() + "'") + ", previousToPausedState=" + (this.previousToPausedState == null ? "null" : "'" + this.previousToPausedState.toString() + "'") + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ")";
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public long timeMs() {
        return this.timeMs;
    }

    public String mirrorTopicState() {
        return this.mirrorTopicState;
    }

    public String previousToPausedState() {
        return this.previousToPausedState;
    }

    public List<Long> stoppedLogEndOffsets() {
        return this.stoppedLogEndOffsets;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MirrorTopicChangeRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public MirrorTopicChangeRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public MirrorTopicChangeRecord setTimeMs(long v) {
        this.timeMs = v;
        return this;
    }

    public MirrorTopicChangeRecord setMirrorTopicState(String v) {
        this.mirrorTopicState = v;
        return this;
    }

    public MirrorTopicChangeRecord setPreviousToPausedState(String v) {
        this.previousToPausedState = v;
        return this;
    }

    public MirrorTopicChangeRecord setStoppedLogEndOffsets(List<Long> v) {
        this.stoppedLogEndOffsets = v;
        return this;
    }
}

