/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ClusterLinkRecord
implements ApiMessage {
    String clusterLinkName;
    Uuid clusterLinkId;
    String tenantPrefix;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of this cluster link."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("tenant_prefix", (Type)Type.COMPACT_NULLABLE_STRING, "The tenant prefix of this cluster link if it exists. Default is null")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ClusterLinkRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ClusterLinkRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ClusterLinkRecord() {
        this.clusterLinkName = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.tenantPrefix = null;
    }

    public short apiKey() {
        return 10000;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterLinkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterLinkName had invalid length " + length);
        }
        this.clusterLinkName = _readable.readString(length);
        this.clusterLinkId = _readable.readUuid();
        this.tenantPrefix = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.tenantPrefix = null;
                        continue block3;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field tenantPrefix had invalid length " + length2);
                    }
                    this.tenantPrefix = _readable.readString(length2);
                    continue block3;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.clusterLinkName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeUuid(this.clusterLinkId);
        if (this.tenantPrefix != null) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.tenantPrefix != null) {
            _writable.writeUnsignedVarint(0);
            byte[] _stringBytes2 = _cache.getSerializedValue((Object)this.tenantPrefix);
            _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.clusterLinkName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterLinkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterLinkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        if (this.tenantPrefix != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.tenantPrefix.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tenantPrefix' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.tenantPrefix, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClusterLinkRecord)) {
            return false;
        }
        ClusterLinkRecord other = (ClusterLinkRecord)obj;
        if (this.clusterLinkName == null ? other.clusterLinkName != null : !this.clusterLinkName.equals(other.clusterLinkName)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.tenantPrefix == null ? other.tenantPrefix != null : !this.tenantPrefix.equals(other.tenantPrefix)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterLinkName == null ? 0 : this.clusterLinkName.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.tenantPrefix == null ? 0 : this.tenantPrefix.hashCode());
        return hashCode;
    }

    public ClusterLinkRecord duplicate() {
        ClusterLinkRecord _duplicate = new ClusterLinkRecord();
        _duplicate.clusterLinkName = this.clusterLinkName;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.tenantPrefix = this.tenantPrefix == null ? null : this.tenantPrefix;
        return _duplicate;
    }

    public String toString() {
        return "ClusterLinkRecord(clusterLinkName=" + (this.clusterLinkName == null ? "null" : "'" + this.clusterLinkName.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ", tenantPrefix=" + (this.tenantPrefix == null ? "null" : "'" + this.tenantPrefix.toString() + "'") + ")";
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String tenantPrefix() {
        return this.tenantPrefix;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ClusterLinkRecord setClusterLinkName(String v) {
        this.clusterLinkName = v;
        return this;
    }

    public ClusterLinkRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public ClusterLinkRecord setTenantPrefix(String v) {
        this.tenantPrefix = v;
        return this;
    }
}

