/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumControllerMetricsTest {
    private static final String EXPECTED_GROUP = "kafka.controller";

    @Test
    public void testKafkaControllerMetricNames() {
        String expectedType = "KafkaController";
        Set expectedMetricNames = Utils.mkSet((Object[])new String[]{"ActiveControllerCount", "GlobalTopicCount", "GlobalPartitionCount", "OfflinePartitionsCount", "PreferredReplicaImbalanceCount"});
        QuorumControllerMetricsTest.assertMetricsCreatedAndRemovedUponClose(expectedType, expectedMetricNames);
    }

    @Test
    public void testControllerEventManagerMetricNames() {
        String expectedType = "ControllerEventManager";
        Set expectedMetricNames = Utils.mkSet((Object[])new String[]{"EventQueueTimeMs", "EventQueueProcessingTimeMs"});
        QuorumControllerMetricsTest.assertMetricsCreatedAndRemovedUponClose(expectedType, expectedMetricNames);
    }

    private static void assertMetricsCreatedAndRemovedUponClose(String expectedType, Set<String> expectedMetricNames) {
        MetricsRegistry registry = new MetricsRegistry();
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry);){
            QuorumControllerMetricsTest.assertMetricsCreated(registry, expectedMetricNames, expectedType);
        }
        QuorumControllerMetricsTest.assertMetricsRemoved(registry, expectedMetricNames, expectedType);
    }

    private static void assertMetricsCreated(MetricsRegistry registry, Set<String> expectedMetricNames, String expectedType) {
        expectedMetricNames.forEach(expectedMetricName -> Assertions.assertTrue((boolean)registry.allMetrics().keySet().stream().anyMatch(metricName -> {
            if (metricName.getGroup().equals(EXPECTED_GROUP) && metricName.getType().equals(expectedType) && metricName.getScope() == null && metricName.getName().equals(expectedMetricName)) {
                String expectedMBeanPrefix = "kafka.controller:type=" + expectedType + ",name=";
                Assertions.assertEquals((Object)(expectedMBeanPrefix + expectedMetricName), (Object)metricName.getMBeanName(), (String)"Incorrect MBean name");
                return true;
            }
            return false;
        }), (String)("Missing metric: " + expectedMetricName)));
    }

    private static void assertMetricsRemoved(MetricsRegistry registry, Set<String> expectedMetricNames, String expectedType) {
        expectedMetricNames.forEach(expectedMetricName -> Assertions.assertTrue((boolean)registry.allMetrics().keySet().stream().noneMatch(metricName -> metricName.getGroup().equals(EXPECTED_GROUP) && metricName.getType().equals(expectedType) && metricName.getScope() == null && metricName.getName().equals(expectedMetricName)), (String)("Metric not removed when closed: " + expectedMetricName)));
    }
}

