/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metalog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metalog.LocalLogManager;
import org.apache.kafka.metalog.MockMetaLogManagerListener;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLogManagerTestEnv
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LocalLogManagerTestEnv.class);
    final AtomicReference<String> firstError = new AtomicReference<Object>(null);
    private final File dir = TestUtils.tempDirectory();
    private final LocalLogManager.SharedLogData shared;
    private final List<LocalLogManager> logManagers;

    public static LocalLogManagerTestEnv createWithMockListeners(int numManagers, Optional<RawSnapshotReader> snapshot) throws Exception {
        LocalLogManagerTestEnv testEnv = new LocalLogManagerTestEnv(numManagers, snapshot);
        try {
            for (LocalLogManager logManager : testEnv.logManagers) {
                logManager.register(new MockMetaLogManagerListener(logManager.nodeId().getAsInt()));
            }
        }
        catch (Exception e) {
            testEnv.close();
            throw e;
        }
        return testEnv;
    }

    public LocalLogManagerTestEnv(int numManagers, Optional<RawSnapshotReader> snapshot) throws Exception {
        this.shared = new LocalLogManager.SharedLogData(snapshot);
        ArrayList<LocalLogManager> newLogManagers = new ArrayList<LocalLogManager>(numManagers);
        try {
            for (int nodeId = 0; nodeId < numManagers; ++nodeId) {
                newLogManagers.add(new LocalLogManager(new LogContext(String.format("[LocalLogManager %d] ", nodeId)), nodeId, this.shared, String.format("LocalLogManager-%d_", nodeId)));
            }
            for (LocalLogManager logManager : newLogManagers) {
                logManager.initialize();
            }
        }
        catch (Throwable t) {
            for (LocalLogManager logManager : newLogManagers) {
                logManager.close();
            }
            throw t;
        }
        this.logManagers = newLogManagers;
    }

    AtomicReference<String> firstError() {
        return this.firstError;
    }

    File dir() {
        return this.dir;
    }

    LeaderAndEpoch waitForLeader() throws InterruptedException {
        AtomicReference<Object> value = new AtomicReference<Object>(null);
        TestUtils.retryOnExceptionWithTimeout((long)20000L, (long)3L, () -> {
            LeaderAndEpoch result = null;
            for (LocalLogManager logManager : this.logManagers) {
                int nodeId;
                LeaderAndEpoch leader = logManager.leaderAndEpoch();
                if (!leader.isLeader(nodeId = logManager.nodeId().getAsInt())) continue;
                if (result != null) {
                    throw new RuntimeException("node " + nodeId + " thinks it's the leader, but so does " + result.leaderId());
                }
                result = leader;
            }
            if (result == null) {
                throw new RuntimeException("No leader found.");
            }
            value.set(result);
        });
        return value.get();
    }

    public List<LocalLogManager> logManagers() {
        return this.logManagers;
    }

    public RawSnapshotReader waitForSnapshot(long committedOffset) throws InterruptedException {
        return this.shared.waitForSnapshot(committedOffset);
    }

    public RawSnapshotReader waitForLatestSnapshot() throws InterruptedException {
        return this.shared.waitForLatestSnapshot();
    }

    public long appendedBytes() {
        return this.shared.appendedBytes();
    }

    public LeaderAndEpoch leaderAndEpoch() {
        return this.shared.leaderAndEpoch();
    }

    @Override
    public void close() throws InterruptedException {
        try {
            for (LocalLogManager logManager : this.logManagers) {
                logManager.beginShutdown();
            }
            for (LocalLogManager logManager : this.logManagers) {
                logManager.close();
            }
            Utils.delete((File)this.dir);
        }
        catch (IOException e) {
            log.error("Error deleting {}", (Object)this.dir.getAbsolutePath(), (Object)e);
        }
    }
}

